/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.core.env;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.AbstractListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.beans.factory.annotation.ConfigServiceBeanBuilder;
import com.alibaba.nacos.spring.core.env.AbstractNacosPropertySourceBuilder;
import com.alibaba.nacos.spring.core.env.NacosPropertySource;
import com.alibaba.nacos.spring.util.NacosBeanUtils;
import com.alibaba.spring.util.BeanUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ObjectUtils;

public class NacosPropertySourcePostProcessor
implements BeanDefinitionRegistryPostProcessor,
BeanFactoryPostProcessor,
EnvironmentAware,
Ordered {
    public static final String BEAN_NAME = "nacosPropertySourcePostProcessor";
    private final Set<String> processedBeanNames = new LinkedHashSet<String>();
    private ConfigurableEnvironment environment;
    private Collection<AbstractNacosPropertySourceBuilder> nacosPropertySourceBuilders;
    private ConfigServiceBeanBuilder configServiceBeanBuilder;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames;
        String[] abstractNacosPropertySourceBuilderBeanNames = BeanUtils.getBeanNames((ConfigurableListableBeanFactory)beanFactory, AbstractNacosPropertySourceBuilder.class);
        this.nacosPropertySourceBuilders = new ArrayList<AbstractNacosPropertySourceBuilder>(abstractNacosPropertySourceBuilderBeanNames.length);
        for (String beanName : abstractNacosPropertySourceBuilderBeanNames) {
            this.nacosPropertySourceBuilders.add((AbstractNacosPropertySourceBuilder)beanFactory.getBean(beanName, AbstractNacosPropertySourceBuilder.class));
        }
        this.configServiceBeanBuilder = NacosBeanUtils.getConfigServiceBeanBuilder((BeanFactory)beanFactory);
        for (String beanName : beanNames = beanFactory.getBeanDefinitionNames()) {
            this.processPropertySource(beanName, beanFactory);
        }
    }

    private void processPropertySource(String beanName, ConfigurableListableBeanFactory beanFactory) {
        if (this.processedBeanNames.contains(beanName)) {
            return;
        }
        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
        List<NacosPropertySource> nacosPropertySources = this.buildNacosPropertySources(beanName, beanDefinition);
        for (NacosPropertySource nacosPropertySource : nacosPropertySources) {
            this.addNacosPropertySource(nacosPropertySource);
            this.addListenerIfAutoRefreshed(nacosPropertySource);
        }
        this.processedBeanNames.add(beanName);
    }

    private List<NacosPropertySource> buildNacosPropertySources(String beanName, BeanDefinition beanDefinition) {
        for (AbstractNacosPropertySourceBuilder builder : this.nacosPropertySourceBuilders) {
            if (!builder.supports(beanDefinition)) continue;
            return builder.build(beanName, beanDefinition);
        }
        return Collections.emptyList();
    }

    private void addNacosPropertySource(NacosPropertySource nacosPropertySource) {
        boolean isRelative;
        MutablePropertySources propertySources = this.environment.getPropertySources();
        boolean first = nacosPropertySource.isFirst();
        String before = nacosPropertySource.getBefore();
        String after = nacosPropertySource.getAfter();
        boolean hasBefore = !ObjectUtils.nullSafeEquals((Object)"", (Object)before);
        boolean hasAfter = !ObjectUtils.nullSafeEquals((Object)"", (Object)after);
        boolean bl = isRelative = hasBefore || hasAfter;
        if (first) {
            propertySources.addFirst((PropertySource)nacosPropertySource);
        } else if (isRelative) {
            if (hasBefore) {
                propertySources.addBefore(before, (PropertySource)nacosPropertySource);
            }
            if (hasAfter) {
                propertySources.addAfter(after, (PropertySource)nacosPropertySource);
            }
        } else {
            propertySources.addLast((PropertySource)nacosPropertySource);
        }
    }

    private void addListenerIfAutoRefreshed(final NacosPropertySource nacosPropertySource) {
        if (!nacosPropertySource.isAutoRefreshed()) {
            return;
        }
        String dataId = nacosPropertySource.getDataId();
        String groupId = nacosPropertySource.getGroupId();
        Map<String, Object> nacosPropertiesAttributes = nacosPropertySource.getAttributesMetadata();
        ConfigService configService = (ConfigService)this.configServiceBeanBuilder.build(nacosPropertiesAttributes);
        try {
            configService.addListener(dataId, groupId, (Listener)new AbstractListener(){

                public void receiveConfigInfo(String config) {
                    String name = nacosPropertySource.getName();
                    NacosPropertySource newNacosPropertySource = new NacosPropertySource(name, config);
                    newNacosPropertySource.copy(nacosPropertySource);
                    MutablePropertySources propertySources = NacosPropertySourcePostProcessor.this.environment.getPropertySources();
                    propertySources.replace(name, (PropertySource)newNacosPropertySource);
                }
            });
        }
        catch (NacosException e) {
            throw new RuntimeException("ConfigService can't add Listener with properties : " + nacosPropertiesAttributes, e);
        }
    }

    public int getOrder() {
        return -2147483647;
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }
}

