/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nls.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nls.client.util.Signer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessToken {
    private static Logger logger = LoggerFactory.getLogger(AccessToken.class);
    private static final String TAG = "AliSpeechSDK";
    private static final String NODE_TOKEN = "Token";
    private String accessKeyId;
    private String accessKeySecret;
    private String token;
    private long expireTime;
    private static final int HTTP_SCCESS_CODE = 200;
    private static final int HTTP_FAIL_CODE = 500;
    private int statusCode;
    private String errorMessage;

    public AccessToken(String accessKeyId, String accessKeySecret) {
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
    }

    public void apply() throws IOException {
        HttpRequest request = new HttpRequest();
        request.authorize(this.accessKeyId, this.accessKeySecret);
        HttpResponse response = AccessToken.send(request);
        if (response.getErrorMessage() == null) {
            String result = response.getResult();
            JSONObject jsonObject = JSON.parseObject((String)result);
            if (jsonObject.containsKey((Object)NODE_TOKEN)) {
                this.token = jsonObject.getJSONObject(NODE_TOKEN).getString("Id");
                this.expireTime = jsonObject.getJSONObject(NODE_TOKEN).getIntValue("ExpireTime");
            } else {
                this.statusCode = 500;
                this.errorMessage = "Received unexpected result: " + result;
            }
        } else {
            logger.error("error to get token,{}", (Object)response);
            this.statusCode = response.getStatusCode();
            this.errorMessage = response.getErrorMessage();
        }
    }

    public String getToken() {
        return this.token;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse send(HttpRequest request) throws IOException {
        OutputStream out = null;
        InputStream inputStream = null;
        try {
            HttpResponse requestResponse;
            URL realUrl = new URL(request.getUrl());
            System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
            HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
            conn.setRequestMethod(request.getMethod());
            if ("POST".equals(request.getMethod())) {
                conn.setDoOutput(true);
                conn.setDoInput(true);
            }
            conn.setUseCaches(false);
            Map<String, String> header = request.getHeader();
            for (String name : header.keySet()) {
                conn.setRequestProperty(name, header.get(name));
            }
            byte[] bodyBytes = request.getBodyBytes();
            if (bodyBytes != null) {
                out = conn.getOutputStream();
                out.write(bodyBytes);
                out.flush();
            }
            int code = conn.getResponseCode();
            Map<String, List<String>> headerFields = conn.getHeaderFields();
            String responseMessage = conn.getResponseMessage();
            inputStream = code == 200 ? conn.getInputStream() : conn.getErrorStream();
            HttpResponse httpResponse = requestResponse = request.parse(code, AccessToken.readAll(inputStream));
            return httpResponse;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static byte[] readAll(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        int len = inputStream.read(bytes);
        while (len > 0) {
            byteArrayOutputStream.write(bytes, 0, len);
            len = inputStream.read(bytes);
        }
        return byteArrayOutputStream.toByteArray();
    }

    class HttpRequest {
        public static final String CHARSET_UTF8 = "UTF-8";
        public static final String METHOD_POST = "POST";
        public static final String HEADER_CONTENT_TYPE = "Content-Type";
        public static final String HEADER_ACCEPT = "Accept";
        public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
        public static final String HEADER_DATE = "Date";
        public static final String HEADER_AUTHORIZATION = "Authorization";
        public static final String HEADER_CONTENT_MD5 = "Content-MD5";
        private static final String URL_PREFIX = "http://nls-meta.cn-shanghai.aliyuncs.com/pop/2018-05-18/tokens";
        public static final String CONTENT_TYPE = "application/octet-stream;charset=utf-8";
        public static final String ACCEPT = "application/json";
        protected String method = "POST";
        protected Map<String, String> header = new HashMap<String, String>();
        private String url = "http://nls-meta.cn-shanghai.aliyuncs.com/pop/2018-05-18/tokens";

        public HttpRequest() {
            this.header.put(HEADER_ACCEPT, ACCEPT);
            this.header.put(HEADER_CONTENT_TYPE, CONTENT_TYPE);
            this.header.put(HEADER_ACCEPT_ENCODING, "identity");
        }

        public String getUrl() {
            return this.url;
        }

        public byte[] getBodyBytes() {
            return null;
        }

        public String getMethod() {
            return METHOD_POST;
        }

        public HttpResponse parse(int statusCode, byte[] bytes) throws IOException {
            HttpResponse response = new HttpResponse();
            response.setStatusCode(statusCode);
            String result = new String(bytes, CHARSET_UTF8);
            if (response.getStatusCode() == 200) {
                response.setResult(result);
            } else {
                response.setErrorMessage(result);
            }
            return response;
        }

        public Map<String, String> getHeader() {
            return this.header;
        }

        public void authorize(String akId, String akSecret) {
            String bodyMd5 = this.getBodyMd5();
            String dateString = Signer.toGMTString();
            this.header.put(HEADER_CONTENT_MD5, bodyMd5);
            this.header.put(HEADER_DATE, dateString);
            String stringToSign = this.method + "\n" + ACCEPT + "\n" + bodyMd5 + "\n" + CONTENT_TYPE + "\n" + dateString + "\n/pop/2018-05-18/tokens";
            String signature = Signer.signString(stringToSign, akSecret);
            String authHeader = "acs " + akId + ":" + signature;
            this.header.put(HEADER_AUTHORIZATION, authHeader);
        }

        protected String getBodyMd5() {
            return "1B2M2Y8AsgTpgAmY7PhCfg==";
        }
    }

    class HttpResponse {
        private int statusCode;
        private String errorMessage;
        String result;
        String text;

        HttpResponse() {
        }

        public String getResult() {
            return this.result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }
}

