/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.rds;

import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.inbound.mysql.rds.data.BinlogFile;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinlogDownloadQueue {
    private static final Logger logger = LoggerFactory.getLogger(BinlogDownloadQueue.class);
    private static final int TIMEOUT = 10000;
    private LinkedBlockingQueue<BinlogFile> downloadQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<Runnable> taskQueue = new LinkedBlockingQueue();
    private LinkedList<BinlogFile> binlogList;
    private final int batchFileSize;
    private Thread downloadThread;
    public boolean running = true;
    private final String destDir;
    private String hostId;
    private int currentSize;
    private String lastDownload;

    public BinlogDownloadQueue(List<BinlogFile> downloadQueue, int batchFileSize, String destDir) throws IOException {
        this.binlogList = new LinkedList<BinlogFile>(downloadQueue);
        this.batchFileSize = batchFileSize;
        this.destDir = destDir;
        this.currentSize = 0;
        this.prepareBinlogList();
        this.cleanDir();
    }

    private void prepareBinlogList() {
        for (BinlogFile binlog : this.binlogList) {
            String fileName = StringUtils.substringBetween((String)binlog.getDownloadLink(), (String)"mysql-bin.", (String)"?");
            binlog.setFileName(fileName);
        }
        Collections.sort(this.binlogList, new Comparator<BinlogFile>(){

            @Override
            public int compare(BinlogFile o1, BinlogFile o2) {
                return o1.getFileName().compareTo(o2.getFileName());
            }
        });
    }

    public void cleanDir() throws IOException {
        File destDirFile = new File(this.destDir);
        FileUtils.forceMkdir((File)destDirFile);
        FileUtils.cleanDirectory((File)destDirFile);
    }

    public void silenceDownload() {
        if (this.downloadThread != null) {
            return;
        }
        this.downloadThread = new Thread((Runnable)new DownloadThread(), "download-" + this.destDir);
        this.downloadThread.setDaemon(true);
        this.downloadThread.start();
    }

    public BinlogFile tryOne() throws Throwable {
        BinlogFile binlogFile = this.binlogList.poll();
        if (binlogFile == null) {
            throw new CanalParseException("download binlog is null");
        }
        this.download(binlogFile);
        this.hostId = binlogFile.getHostInstanceID();
        ++this.currentSize;
        return binlogFile;
    }

    public void notifyNotMatch() {
        --this.currentSize;
        this.filter(this.hostId);
    }

    private void filter(String hostInstanceId) {
        Iterator it = this.binlogList.iterator();
        while (it.hasNext()) {
            BinlogFile bf = (BinlogFile)it.next();
            if (bf.getHostInstanceID().equalsIgnoreCase(hostInstanceId)) {
                it.remove();
                continue;
            }
            this.hostId = bf.getHostInstanceID();
        }
    }

    public boolean isLastFile(String fileName) {
        String needCompareName = this.lastDownload;
        if (StringUtils.isNotEmpty((String)needCompareName) && StringUtils.endsWith((String)needCompareName, (String)"tar")) {
            needCompareName = needCompareName.substring(0, needCompareName.indexOf("."));
        }
        return (needCompareName == null || fileName.equalsIgnoreCase(needCompareName)) && this.binlogList.isEmpty();
    }

    public void prepare() throws InterruptedException {
        for (int i = this.currentSize; i < this.batchFileSize && !this.binlogList.isEmpty(); ++i) {
            BinlogFile binlogFile = null;
            while (!this.binlogList.isEmpty() && !(binlogFile = this.binlogList.poll()).getHostInstanceID().equalsIgnoreCase(this.hostId)) {
            }
            if (binlogFile == null) break;
            this.downloadQueue.put(binlogFile);
            this.lastDownload = "mysql-bin." + binlogFile.getFileName();
            ++this.currentSize;
        }
    }

    public void downOne() {
        --this.currentSize;
    }

    public void release() {
        this.running = false;
        this.currentSize = 0;
        this.binlogList.clear();
        this.downloadQueue.clear();
        try {
            this.downloadThread.interrupt();
            this.downloadThread.join();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.downloadThread = null;
        }
    }

    private void download(BinlogFile binlogFile) throws Throwable {
        String downloadLink = binlogFile.getDownloadLink();
        String fileName = binlogFile.getFileName();
        downloadLink = downloadLink.trim();
        CloseableHttpClient httpClient = null;
        if (downloadLink.startsWith("https")) {
            HttpClientBuilder builder = HttpClientBuilder.create();
            builder.setMaxConnPerRoute(50);
            builder.setMaxConnTotal(100);
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            }).build();
            httpClient = HttpClientBuilder.create().setSSLContext(sslContext).setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build())).build();
        } else {
            httpClient = HttpClientBuilder.create().setMaxConnPerRoute(50).setMaxConnTotal(100).build();
        }
        HttpGet httpGet = new HttpGet(downloadLink);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
        httpGet.setConfig(requestConfig);
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != HttpResponseStatus.OK.code()) {
            throw new RuntimeException("download failed , url:" + downloadLink + " , statusCode:" + statusCode);
        }
        BinlogDownloadQueue.saveFile(new File(this.destDir), "mysql-bin." + fileName, (HttpResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveFile(File parentFile, String fileName, HttpResponse response) throws IOException {
        block15: {
            InputStream is = response.getEntity().getContent();
            long totalSize = Long.parseLong(response.getFirstHeader("Content-Length").getValue());
            if (response.getFirstHeader("Content-Disposition") != null) {
                fileName = response.getFirstHeader("Content-Disposition").getValue();
                fileName = StringUtils.substringAfter((String)fileName, (String)"filename=");
            }
            boolean isTar = StringUtils.endsWith((String)fileName, (String)".tar");
            FileUtils.forceMkdir((File)parentFile);
            FileOutputStream fos = null;
            try {
                if (isTar) {
                    TarArchiveInputStream tais = new TarArchiveInputStream(is);
                    TarArchiveEntry tarArchiveEntry = null;
                    while ((tarArchiveEntry = tais.getNextTarEntry()) != null) {
                        String name = tarArchiveEntry.getName();
                        File tarFile = new File(parentFile, name + ".tmp");
                        logger.info("start to download file " + tarFile.getName());
                        if (tarFile.exists()) {
                            tarFile.delete();
                        }
                        BufferedOutputStream bos = null;
                        try {
                            bos = new BufferedOutputStream(new FileOutputStream(tarFile));
                            int read = -1;
                            byte[] buffer = new byte[1024];
                            while ((read = tais.read(buffer)) != -1) {
                                bos.write(buffer, 0, read);
                            }
                            logger.info("download file " + tarFile.getName() + " end!");
                            tarFile.renameTo(new File(parentFile, name));
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(bos);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((OutputStream)bos);
                    }
                    tais.close();
                    break block15;
                }
                File file = new File(parentFile, fileName + ".tmp");
                if (file.exists()) {
                    file.delete();
                }
                if (!file.isFile()) {
                    file.createNewFile();
                }
                try {
                    int len;
                    fos = new FileOutputStream(file);
                    byte[] buffer = new byte[1024];
                    long copySize = 0L;
                    long nextPrintProgress = 0L;
                    logger.info("start to download file " + file.getName());
                    while ((len = is.read(buffer)) != -1) {
                        fos.write(buffer, 0, len);
                        long progress = (copySize += (long)len) * 100L / totalSize;
                        if (progress < nextPrintProgress) continue;
                        logger.info("download " + file.getName() + " progress : " + progress + "% , download size : " + copySize + ", total size : " + totalSize);
                        nextPrintProgress += 10L;
                    }
                    logger.info("download file " + file.getName() + " end!");
                    fos.flush();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fos);
                file.renameTo(new File(parentFile, fileName));
            }
            finally {
                IOUtils.closeQuietly(fos);
            }
        }
    }

    public void execute(Runnable runnable) throws InterruptedException {
        this.taskQueue.put(runnable);
    }

    private class DownloadThread
    implements Runnable {
        private DownloadThread() {
        }

        @Override
        public void run() {
            while (BinlogDownloadQueue.this.running) {
                BinlogFile binlogFile = null;
                try {
                    Runnable runnable;
                    binlogFile = (BinlogFile)BinlogDownloadQueue.this.downloadQueue.poll(5000L, TimeUnit.MILLISECONDS);
                    if (binlogFile != null) {
                        int retry = 1;
                        while (true) {
                            try {
                                BinlogDownloadQueue.this.download(binlogFile);
                            }
                            catch (Throwable e) {
                                if (retry % 10 == 0) {
                                    ++retry;
                                    try {
                                        logger.warn("download failed + " + binlogFile.toString() + "], retry : " + retry, e);
                                        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100 * retry));
                                    }
                                    catch (Throwable e1) {
                                        logger.error("write error failed", e1);
                                    }
                                    continue;
                                }
                                ++retry;
                                continue;
                            }
                            break;
                        }
                    }
                    if ((runnable = (Runnable)BinlogDownloadQueue.this.taskQueue.poll(5000L, TimeUnit.MILLISECONDS)) == null) continue;
                    runnable.run();
                }
                catch (Throwable e) {
                    logger.error("task process failed", e);
                }
            }
        }
    }
}

