/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.prometheus;

import com.alibaba.otter.canal.instance.core.CanalInstance;
import com.alibaba.otter.canal.prometheus.InstanceRegistry;
import com.alibaba.otter.canal.prometheus.impl.EntryCollector;
import com.alibaba.otter.canal.prometheus.impl.MetaCollector;
import com.alibaba.otter.canal.prometheus.impl.ParserCollector;
import com.alibaba.otter.canal.prometheus.impl.SinkCollector;
import com.alibaba.otter.canal.prometheus.impl.StoreCollector;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalInstanceExports {
    private static final Logger logger = LoggerFactory.getLogger(CanalInstanceExports.class);
    public static final String DEST = "destination";
    public static final String[] DEST_LABELS = new String[]{"destination"};
    public static final List<String> DEST_LABELS_LIST = Collections.singletonList("destination");
    private final Collector storeCollector = StoreCollector.instance();
    private final Collector entryCollector = EntryCollector.instance();
    private final Collector metaCollector = MetaCollector.instance();
    private final Collector sinkCollector = SinkCollector.instance();
    private final Collector parserCollector = ParserCollector.instance();

    private CanalInstanceExports() {
    }

    public static CanalInstanceExports instance() {
        return SingletonHolder.SINGLETON;
    }

    public void initialize() {
        this.storeCollector.register();
        this.entryCollector.register();
        this.metaCollector.register();
        this.sinkCollector.register();
        this.parserCollector.register();
    }

    public void terminate() {
        CollectorRegistry.defaultRegistry.unregister(this.storeCollector);
        CollectorRegistry.defaultRegistry.unregister(this.entryCollector);
        CollectorRegistry.defaultRegistry.unregister(this.metaCollector);
        CollectorRegistry.defaultRegistry.unregister(this.sinkCollector);
        CollectorRegistry.defaultRegistry.unregister(this.parserCollector);
    }

    void register(CanalInstance instance) {
        this.requiredInstanceRegistry(this.storeCollector).register(instance);
        this.requiredInstanceRegistry(this.entryCollector).register(instance);
        this.requiredInstanceRegistry(this.metaCollector).register(instance);
        this.requiredInstanceRegistry(this.sinkCollector).register(instance);
        this.requiredInstanceRegistry(this.parserCollector).register(instance);
        logger.info("Successfully register metrics for instance {}.", (Object)instance.getDestination());
    }

    void unregister(CanalInstance instance) {
        this.requiredInstanceRegistry(this.storeCollector).unregister(instance);
        this.requiredInstanceRegistry(this.entryCollector).unregister(instance);
        this.requiredInstanceRegistry(this.metaCollector).unregister(instance);
        this.requiredInstanceRegistry(this.sinkCollector).unregister(instance);
        this.requiredInstanceRegistry(this.parserCollector).unregister(instance);
        logger.info("Successfully unregister metrics for instance {}.", (Object)instance.getDestination());
    }

    private InstanceRegistry requiredInstanceRegistry(Collector collector) {
        if (!(collector instanceof InstanceRegistry)) {
            throw new IllegalArgumentException("Canal prometheus collector need to implement InstanceRegistry.");
        }
        return (InstanceRegistry)collector;
    }

    private static class SingletonHolder {
        private static final CanalInstanceExports SINGLETON = new CanalInstanceExports();

        private SingletonHolder() {
        }
    }
}

