/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.prometheus.impl;

import com.alibaba.otter.canal.prometheus.CanalInstanceExports;
import com.alibaba.otter.canal.protocol.CanalPacket;
import com.alibaba.otter.canal.server.netty.ClientInstanceProfiler;
import com.alibaba.otter.canal.server.netty.listener.ChannelFutureAggregator;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;

public class PrometheusClientInstanceProfiler
implements ClientInstanceProfiler {
    private static final long NANO_PER_MILLI = 1000000L;
    private static final String PACKET_TYPE = "canal_instance_client_packets";
    private static final String OUTBOUND_BYTES = "canal_instance_client_bytes";
    private static final String EMPTY_BATCHES = "canal_instance_client_empty_batches";
    private static final String ERRORS = "canal_instance_client_request_error";
    private static final String LATENCY = "canal_instance_client_request_latency";
    private final Counter outboundCounter = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().labelNames(CanalInstanceExports.DEST_LABELS)).name("canal_instance_client_bytes")).help("Total bytes sent to client.")).create();
    private final Counter packetsCounter = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().labelNames(new String[]{"destination", "packetType"})).name("canal_instance_client_packets")).help("Total packets sent to client.")).create();
    private final Counter emptyBatchesCounter = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().labelNames(CanalInstanceExports.DEST_LABELS)).name("canal_instance_client_empty_batches")).help("Total empty batches sent to client.")).create();
    private final Counter errorsCounter = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().labelNames(new String[]{"destination", "errorCode"})).name("canal_instance_client_request_error")).help("Total client request errors.")).create();
    private final Histogram responseLatency = ((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().labelNames(CanalInstanceExports.DEST_LABELS)).name("canal_instance_client_request_latency")).help("Client request latency.")).buckets(new double[]{2.5, 10.0, 25.0, 100.0}).create();
    private volatile boolean running = false;

    public static PrometheusClientInstanceProfiler instance() {
        return SingletonHolder.SINGLETON;
    }

    private PrometheusClientInstanceProfiler() {
    }

    public void profiling(ChannelFutureAggregator.ClientRequestResult result) {
        String destination = result.getDestination();
        CanalPacket.PacketType type = result.getType();
        ((Counter.Child)this.outboundCounter.labels(new String[]{destination})).inc((double)result.getAmount());
        short errorCode = result.getErrorCode();
        if (errorCode > 0) {
            ((Counter.Child)this.errorsCounter.labels(new String[]{destination, Short.toString(errorCode)})).inc();
        }
        long latency = result.getLatency();
        ((Histogram.Child)this.responseLatency.labels(new String[]{destination})).observe((double)latency / 1000000.0);
        switch (type) {
            case GET: {
                boolean empty = result.getEmpty();
                if (empty) {
                    ((Counter.Child)this.emptyBatchesCounter.labels(new String[]{destination})).inc();
                    break;
                }
                ((Counter.Child)this.packetsCounter.labels(new String[]{destination, type.name()})).inc();
                break;
            }
            default: {
                ((Counter.Child)this.packetsCounter.labels(new String[]{destination, type.name()})).inc();
            }
        }
    }

    public void start() {
        if (this.outboundCounter != null) {
            this.outboundCounter.register();
        }
        if (this.packetsCounter != null) {
            this.packetsCounter.register();
        }
        if (this.emptyBatchesCounter != null) {
            this.emptyBatchesCounter.register();
        }
        if (this.errorsCounter != null) {
            this.errorsCounter.register();
        }
        if (this.responseLatency != null) {
            this.responseLatency.register();
        }
        this.running = true;
    }

    public void stop() {
        this.running = false;
        if (this.outboundCounter != null) {
            CollectorRegistry.defaultRegistry.unregister((Collector)this.outboundCounter);
        }
        if (this.packetsCounter != null) {
            CollectorRegistry.defaultRegistry.unregister((Collector)this.packetsCounter);
        }
        if (this.emptyBatchesCounter != null) {
            CollectorRegistry.defaultRegistry.unregister((Collector)this.emptyBatchesCounter);
        }
        if (this.errorsCounter != null) {
            CollectorRegistry.defaultRegistry.unregister((Collector)this.errorsCounter);
        }
        if (this.responseLatency != null) {
            CollectorRegistry.defaultRegistry.unregister((Collector)this.responseLatency);
        }
    }

    public boolean isStart() {
        return this.running;
    }

    private static class SingletonHolder {
        private static final PrometheusClientInstanceProfiler SINGLETON = new PrometheusClientInstanceProfiler();

        private SingletonHolder() {
        }
    }
}

