/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.server.netty.listener;

import com.alibaba.otter.canal.protocol.CanalPacket;
import com.alibaba.otter.canal.server.netty.CanalServerWithNettyProfiler;
import com.alibaba.otter.canal.server.netty.NettyUtils;
import com.google.common.base.Preconditions;
import com.google.protobuf.GeneratedMessageV3;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;

public class ChannelFutureAggregator
implements ChannelFutureListener {
    private ClientRequestResult result;

    public ChannelFutureAggregator(String destination, GeneratedMessageV3 request, CanalPacket.PacketType type, int amount, long latency, boolean empty) {
        this(destination, request, type, amount, latency, empty, 0);
    }

    public ChannelFutureAggregator(String destination, GeneratedMessageV3 request, CanalPacket.PacketType type, int amount, long latency) {
        this(destination, request, type, amount, latency, false, 0);
    }

    public ChannelFutureAggregator(String destination, GeneratedMessageV3 request, CanalPacket.PacketType type, int amount, long latency, short errorCode) {
        this(destination, request, type, amount, latency, false, errorCode);
    }

    private ChannelFutureAggregator(String destination, GeneratedMessageV3 request, CanalPacket.PacketType type, int amount, long latency, boolean empty, short errorCode) {
        this.result = new ClientRequestResult.Builder().destination(destination).type(type).request(request).amount(amount + NettyUtils.HEADER_LENGTH).latency(latency).errorCode(errorCode).empty(empty).build();
    }

    public void operationComplete(ChannelFuture future) {
        if (future != null && future.getCause() != null) {
            this.result.channelError = future.getCause();
        }
        CanalServerWithNettyProfiler.profiler().profiling(this.result);
    }

    public static class ClientRequestResult {
        private String destination;
        private CanalPacket.PacketType type;
        private GeneratedMessageV3 request;
        private int amount;
        private long latency;
        private short errorCode;
        private boolean empty;
        private Throwable channelError;

        private ClientRequestResult() {
        }

        private ClientRequestResult(Builder builder) {
            this.destination = (String)Preconditions.checkNotNull((Object)builder.destination);
            this.type = (CanalPacket.PacketType)Preconditions.checkNotNull((Object)builder.type);
            this.request = builder.request;
            this.amount = builder.amount;
            this.latency = builder.latency;
            this.errorCode = builder.errorCode;
            this.empty = builder.empty;
            this.channelError = builder.channelError;
        }

        public String getDestination() {
            return this.destination;
        }

        public CanalPacket.PacketType getType() {
            return this.type;
        }

        public GeneratedMessageV3 getRequest() {
            return this.request;
        }

        public int getAmount() {
            return this.amount;
        }

        public long getLatency() {
            return this.latency;
        }

        public short getErrorCode() {
            return this.errorCode;
        }

        public boolean getEmpty() {
            return this.empty;
        }

        public Throwable getChannelError() {
            return this.channelError;
        }

        public static class Builder {
            private String destination;
            private CanalPacket.PacketType type;
            private GeneratedMessageV3 request;
            private int amount;
            private long latency;
            private short errorCode;
            private boolean empty;
            private Throwable channelError;

            Builder destination(String destination) {
                this.destination = destination;
                return this;
            }

            Builder type(CanalPacket.PacketType type) {
                this.type = type;
                return this;
            }

            Builder request(GeneratedMessageV3 request) {
                this.request = request;
                return this;
            }

            Builder amount(int amount) {
                this.amount = amount;
                return this;
            }

            Builder latency(long latency) {
                this.latency = latency;
                return this;
            }

            Builder errorCode(short errorCode) {
                this.errorCode = errorCode;
                return this;
            }

            Builder empty(boolean empty) {
                this.empty = empty;
                return this;
            }

            public Builder channelError(Throwable channelError) {
                this.channelError = channelError;
                return this;
            }

            public Builder fromPrototype(ClientRequestResult prototype) {
                this.destination = prototype.destination;
                this.type = prototype.type;
                this.request = prototype.request;
                this.amount = prototype.amount;
                this.latency = prototype.latency;
                this.errorCode = prototype.errorCode;
                this.empty = prototype.empty;
                this.channelError = prototype.channelError;
                return this;
            }

            ClientRequestResult build() {
                return new ClientRequestResult(this);
            }
        }
    }
}

