/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.util.PojoUtils;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;

public abstract class AbstractPojoRule
extends AbstractAliRule {
    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        if (this.hasPojoInJavaFile(node)) {
            return super.visit(node, data);
        }
        return data;
    }

    private boolean hasPojoInJavaFile(ASTCompilationUnit node) {
        List klasses = node.findDescendantsOfType(ASTClassOrInterfaceDeclaration.class);
        for (ASTClassOrInterfaceDeclaration klass : klasses) {
            if (!this.isPojo(klass)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPojo(ASTClassOrInterfaceDeclaration node) {
        return PojoUtils.isPojo(node);
    }
}

