/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.comment;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.comment.AbstractAliCommentRule;
import com.alibaba.p3c.pmd.lang.java.rule.util.NodeSortUtils;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.Comment;

public class AvoidCommentBehindStatementRule
extends AbstractAliCommentRule {
    public Object visit(ASTCompilationUnit cUnit, Object data) {
        SortedMap<Integer, Node> itemsByLineNumber = this.orderedCommentsAndExpressions(cUnit);
        AbstractJavaNode lastNode = null;
        for (Map.Entry<Integer, Node> entry : itemsByLineNumber.entrySet()) {
            Node value = entry.getValue();
            if (value instanceof AbstractJavaNode) {
                lastNode = (AbstractJavaNode)value;
                continue;
            }
            if (!(value instanceof Comment)) continue;
            Comment comment = (Comment)value;
            if (lastNode == null || comment.getBeginLine() != lastNode.getBeginLine() || comment.getEndColumn() <= lastNode.getBeginColumn()) continue;
            this.addViolationWithMessage(data, (Node)lastNode, I18nResources.getMessage("java.comment.AvoidCommentBehindStatementRule.violation.msg"), comment.getBeginLine(), comment.getEndLine());
        }
        return super.visit(cUnit, data);
    }

    protected SortedMap<Integer, Node> orderedCommentsAndExpressions(ASTCompilationUnit cUnit) {
        TreeMap<Integer, Node> itemsByLineNumber = new TreeMap<Integer, Node>();
        List expressionNodes = cUnit.findDescendantsOfType(ASTExpression.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, expressionNodes);
        List fieldNodes = cUnit.findDescendantsOfType(ASTFieldDeclaration.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, fieldNodes);
        List enumConstantNodes = cUnit.findDescendantsOfType(ASTEnumConstant.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, enumConstantNodes);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, cUnit.getComments());
        return itemsByLineNumber;
    }
}

