/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.naming;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJUnitRule;
import net.sourceforge.pmd.lang.rule.AbstractRule;

public class TestClassShouldEndWithTestNamingRule
extends AbstractJUnitRule {
    private static final String TEST_SUFFIX = "Test";

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isAbstract() || node.isInterface() || node.isNested()) {
            return super.visit(node, data);
        }
        List m = node.findDescendantsOfType(ASTMethodDeclaration.class);
        boolean testsFound = false;
        if (m != null) {
            for (ASTMethodDeclaration md : m) {
                if (this.isInInnerClassOrInterface(md) || !this.isJUnitMethod(md, data)) continue;
                testsFound = true;
            }
        }
        if (testsFound && !node.getImage().endsWith(TEST_SUFFIX)) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data, I18nResources.getMessage("java.naming.TestClassShouldEndWithTestNamingRule.violation.msg", node.getImage()));
        }
        return super.visit(node, data);
    }

    private boolean isInInnerClassOrInterface(ASTMethodDeclaration md) {
        ASTClassOrInterfaceDeclaration p = (ASTClassOrInterfaceDeclaration)md.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        return p != null && p.isNested();
    }

    public void setDescription(String description) {
        super.setDescription(I18nResources.getMessageWithExceptionHandled(description));
    }

    public void setMessage(String message) {
        super.setMessage(I18nResources.getMessageWithExceptionHandled(message));
    }

    public void addViolationWithMessage(Object data, Node node, String message) {
        super.addViolationWithMessage(data, node, I18nResources.getMessageWithExceptionHandled(message));
    }

    public void addViolationWithMessage(Object data, Node node, String message, Object[] args) {
        super.addViolationWithMessage(data, node, String.format(I18nResources.getMessageWithExceptionHandled(message), args));
    }
}

