/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.oop;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.rule.util.NodeUtils;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.Token;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;
import org.jaxen.JaxenException;

public class EqualsAvoidNullRule
extends AbstractAliRule {
    private static final String XPATH = "//PrimaryExpression[(PrimaryPrefix[Name[(ends-with(@Image, '.equals'))]]|PrimarySuffix[@Image='equals'])[(../PrimarySuffix/Arguments/ArgumentList/Expression/PrimaryExpression/PrimaryPrefix) and ( count(../PrimarySuffix/Arguments/ArgumentList/Expression) = 1 )]][not(ancestor::Expression/ConditionalAndExpression//EqualityExpression[@Image='!=']//NullLiteral)][not(ancestor::Expression/ConditionalOrExpression//EqualityExpression[@Image='==']//NullLiteral)]";
    private static final String INVOCATION_PREFIX_XPATH = "PrimarySuffix/Arguments/ArgumentList/Expression/PrimaryExpression[not(PrimarySuffix)]/PrimaryPrefix";
    private static final String METHOD_EQUALS = "equals";

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        try {
            List equalsInvocations = node.findChildNodesWithXPath(XPATH);
            if (equalsInvocations == null || equalsInvocations.isEmpty()) {
                return super.visit(node, data);
            }
            for (Node invocation : equalsInvocations) {
                ASTFieldDeclaration field;
                boolean nameInvalid;
                if (this.callerIsLiteral(invocation)) {
                    return super.visit(node, data);
                }
                List simpleExpressions = invocation.findChildNodesWithXPath(INVOCATION_PREFIX_XPATH);
                if (simpleExpressions == null || simpleExpressions.isEmpty()) {
                    return super.visit(node, data);
                }
                ASTPrimaryPrefix right = (ASTPrimaryPrefix)simpleExpressions.get(0);
                if (right.getFirstChildOfType(ASTLiteral.class) != null) {
                    ASTLiteral literal = (ASTLiteral)right.getFirstChildOfType(ASTLiteral.class);
                    if (!literal.isStringLiteral()) continue;
                    this.addRuleViolation(data, invocation);
                    continue;
                }
                ASTName name = (ASTName)right.getFirstChildOfType(ASTName.class);
                boolean bl = nameInvalid = name == null || name.getNameDeclaration() == null || name.getNameDeclaration().getNode() == null;
                if (nameInvalid) {
                    return super.visit(node, data);
                }
                ScopedNode nameNode = name.getNameDeclaration().getNode();
                if (!(nameNode instanceof ASTVariableDeclaratorId) || !(nameNode.getNthParent(2) instanceof ASTFieldDeclaration) || !NodeUtils.isConstant(field = (ASTFieldDeclaration)nameNode.getNthParent(2))) continue;
                this.addRuleViolation(data, invocation);
            }
        }
        catch (JaxenException e) {
            throw new RuntimeException("XPath expression //PrimaryExpression[(PrimaryPrefix[Name[(ends-with(@Image, '.equals'))]]|PrimarySuffix[@Image='equals'])[(../PrimarySuffix/Arguments/ArgumentList/Expression/PrimaryExpression/PrimaryPrefix) and ( count(../PrimarySuffix/Arguments/ArgumentList/Expression) = 1 )]][not(ancestor::Expression/ConditionalAndExpression//EqualityExpression[@Image='!=']//NullLiteral)][not(ancestor::Expression/ConditionalOrExpression//EqualityExpression[@Image='==']//NullLiteral)] failed: " + e.getLocalizedMessage(), e);
        }
        return super.visit(node, data);
    }

    private boolean callerIsLiteral(Node equalsInvocation) {
        if (equalsInvocation instanceof ASTPrimaryExpression) {
            ASTPrimaryPrefix caller = (ASTPrimaryPrefix)equalsInvocation.getFirstChildOfType(ASTPrimaryPrefix.class);
            return caller != null && caller.getFirstChildOfType(ASTLiteral.class) != null;
        }
        return false;
    }

    private String getInvocationName(AbstractJavaNode javaNode) {
        Token token = (Token)javaNode.jjtGetFirstToken();
        StringBuilder sb = new StringBuilder(token.image).append(token.image);
        while (token.next != null && token.next.image != null && !METHOD_EQUALS.equals(token.next.image)) {
            token = token.next;
            sb.append(token.image);
        }
        if (sb.charAt(sb.length() - 1) == '.') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private void addRuleViolation(Object data, Node invocation) {
        if (invocation instanceof AbstractJavaNode) {
            AbstractJavaNode javaNode = (AbstractJavaNode)invocation;
            this.addViolationWithMessage(data, invocation, "java.oop.EqualsAvoidNullRule.violation.msg", new Object[]{this.getInvocationName(javaNode)});
        } else {
            this.addViolation(data, invocation);
        }
    }
}

