/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.other;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import com.alibaba.p3c.pmd.lang.java.rule.util.NodeSortUtils;
import com.alibaba.p3c.pmd.lang.java.util.ViolationUtils;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.ast.FormalComment;
import net.sourceforge.pmd.lang.java.ast.MultiLineComment;
import net.sourceforge.pmd.lang.java.ast.SingleLineComment;
import net.sourceforge.pmd.lang.java.ast.Token;
import net.sourceforge.pmd.lang.rule.AbstractRule;

public class MethodTooLongRule
extends AbstractAliRule {
    private static final int MAX_LINE_COUNT = 80;
    private static final String ANNOTATION_PREFIX = "@";
    private SortedMap<Integer, Node> sortedNodeAndComment;

    @Override
    public Object visit(ASTCompilationUnit cUnit, Object data) {
        this.sortedNodeAndComment = this.orderedCommentsAndExpressions(cUnit);
        return super.visit(cUnit, data);
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        int commentLineCount;
        ASTClassOrInterfaceBodyDeclaration classOrInterfaceBodyDecl = (ASTClassOrInterfaceBodyDeclaration)node.jjtGetParent();
        int startLine = classOrInterfaceBodyDecl.getBeginLine();
        int endLine = classOrInterfaceBodyDecl.getEndLine();
        Node firstChild = classOrInterfaceBodyDecl.jjtGetChild(0);
        if (firstChild instanceof ASTAnnotation) {
            Token firstToken = (Token)classOrInterfaceBodyDecl.jjtGetFirstToken();
            if (ANNOTATION_PREFIX.equals(firstToken.image)) {
                ASTAnnotation annotation = (ASTAnnotation)firstChild;
                Token lastToken = (Token)annotation.jjtGetLastToken();
                Token next = lastToken.next;
                startLine = next.beginLine;
            }
        }
        if (endLine - startLine - (commentLineCount = this.getCommentLineCount(node)) + 1 > 80) {
            ViolationUtils.addViolationWithPrecisePosition((AbstractRule)this, (Node)node, data, I18nResources.getMessage("java.other.MethodTooLongRule.violation.msg", node.getName()));
        }
        return data;
    }

    protected SortedMap<Integer, Node> orderedCommentsAndExpressions(ASTCompilationUnit cUnit) {
        TreeMap<Integer, Node> itemsByLineNumber = new TreeMap<Integer, Node>();
        List expressionNodes = cUnit.findDescendantsOfType(ASTExpression.class);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, expressionNodes);
        NodeSortUtils.addNodesToSortedMap(itemsByLineNumber, cUnit.getComments());
        return itemsByLineNumber;
    }

    private int getCommentLineCount(ASTMethodDeclaration methodDecl) {
        int lineCount = 0;
        AbstractJavaNode lastNode = null;
        for (Map.Entry<Integer, Node> entry : this.sortedNodeAndComment.entrySet()) {
            Node value = entry.getValue();
            if (value.getBeginLine() <= methodDecl.getBeginLine()) continue;
            if (value.getBeginLine() > methodDecl.getEndLine()) break;
            if (value instanceof AbstractJavaNode) {
                lastNode = (AbstractJavaNode)value;
                continue;
            }
            if (value instanceof FormalComment || value instanceof MultiLineComment) {
                Comment comment = (Comment)value;
                lineCount += comment.getEndLine() - comment.getBeginLine() + 1;
                continue;
            }
            if (!(value instanceof SingleLineComment)) continue;
            SingleLineComment singleLineComment = (SingleLineComment)value;
            if (lastNode != null && singleLineComment.getBeginLine() == lastNode.getBeginLine()) continue;
            ++lineCount;
        }
        return lineCount;
    }
}

