/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.java.rule.set;

import com.alibaba.p3c.pmd.lang.java.rule.AbstractAliRule;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import org.jaxen.JaxenException;

public class ConcurrentExceptionWithModifyOriginSubListRule
extends AbstractAliRule {
    private static final String ADD = ".add";
    private static final String REMOVE = ".remove";
    private static final String CLEAR = ".clear";
    private static final String XPATH = "//VariableDeclarator[../Type/ReferenceType/ClassOrInterfaceType[@Image='List']]/VariableInitializer/Expression/PrimaryExpression/PrimaryPrefix/Name[ends-with(@Image,'.subList')]";
    private static final String CHILD_XPATH = "BlockStatement/Statement/StatementExpression/PrimaryExpression/PrimaryPrefix/Name";

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        try {
            List nodes = node.findChildNodesWithXPath(XPATH);
            for (Node item : nodes) {
                if (!(item instanceof ASTName)) continue;
                String valName = this.getBeforeSubListVal(item.getImage());
                ASTBlock blockNode = (ASTBlock)item.getFirstParentOfType(ASTBlock.class);
                if (blockNode == null || valName == null) continue;
                List blockNodes = blockNode.findChildNodesWithXPath(CHILD_XPATH);
                for (Node blockItem : blockNodes) {
                    if (blockItem.getBeginLine() < item.getBeginLine() || !this.checkBlockNodesValid(valName, blockItem)) continue;
                    this.addViolationWithMessage(data, blockItem, "java.set.ConcurrentExceptionWithModifyOriginSubListRule.violation.msg", new Object[]{blockItem.getImage()});
                }
            }
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        return super.visit(node, data);
    }

    private String getBeforeSubListVal(String image) {
        return image == null ? null : image.substring(0, image.indexOf("."));
    }

    private boolean checkBlockNodesValid(String variableName, Node item) {
        String name;
        return item instanceof ASTName && this.judgeName(name = item.getImage(), variableName);
    }

    private boolean judgeName(String name, String variableName) {
        return name.equals(variableName + ADD) || name.equals(variableName + REMOVE) || name.equals(variableName + CLEAR);
    }
}

