/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.p3c.pmd.lang.vm.rule.other;

import com.alibaba.p3c.pmd.I18nResources;
import com.alibaba.p3c.pmd.lang.AbstractXpathRule;
import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.vm.ast.ASTDirective;
import net.sourceforge.pmd.lang.vm.ast.AbstractVmNode;
import net.sourceforge.pmd.lang.vm.ast.Token;

public class UseQuietReferenceNotationRule
extends AbstractXpathRule {
    private static final Pattern ALLOW_FILE_PATTERN = Pattern.compile(".*(template|velocity).*");
    private static final String UT_FILE_NAME = "n/a";
    private static final String MACRO_NAME = "macro";
    private static final String XPATH = "//Reference[matches(@literal, \"^\\$[^!]+\") and ./preceding-sibling::Text and ./following-sibling::Text]";

    public UseQuietReferenceNotationRule() {
        this.setXPath(XPATH);
    }

    public void evaluate(Node node, RuleContext ctx) {
        String sourceCodeFilename = ctx.getSourceCodeFilename();
        if (!UT_FILE_NAME.equals(sourceCodeFilename) && !ALLOW_FILE_PATTERN.matcher(sourceCodeFilename).matches()) {
            return;
        }
        if (this.checkMacro(node)) {
            return;
        }
        super.evaluate(node, ctx);
    }

    public void addViolation(Object data, Node node, String arg) {
        String name = this.getIdentifyName((AbstractVmNode)node);
        String text = I18nResources.getMessage("vm.other.UseQuietReferenceNotationRule.violation.msg", name);
        this.addViolationWithMessage(data, node, text);
    }

    private String getIdentifyName(AbstractVmNode node) {
        Token token = node.getFirstToken();
        StringBuilder sb = new StringBuilder();
        while (token.kind >= 68 && token.kind < 71) {
            if (token.kind != 70) {
                sb.append(token.image);
            }
            token = token.next;
        }
        return sb.toString();
    }

    private boolean checkMacro(Node node) {
        List directiveParents = node.getParentsOfType(ASTDirective.class);
        for (ASTDirective directiveParent : directiveParents) {
            if (!MACRO_NAME.equals(directiveParent.getDirectiveName())) continue;
            return true;
        }
        return false;
    }
}

