/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx;

import com.alibaba.polardbx.HaManager;
import com.alibaba.polardbx.common.XClusterNodeBasic;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class HaConnection
implements Connection {
    private final HaManager haManager;
    private final String leader;
    private final Connection realConnection;
    private final boolean smoothSwitchover;

    public HaConnection(HaManager haManager, String leader, Connection realConnection, boolean smoothSwitchover) {
        this.haManager = haManager;
        this.leader = leader;
        this.realConnection = realConnection;
        this.smoothSwitchover = smoothSwitchover;
    }

    private void checkHa() throws SQLException {
        XClusterNodeBasic currentLeader = this.haManager.getLeaderRef().get();
        if (currentLeader != null && !currentLeader.getTag().equals(this.leader)) {
            this.realConnection.close();
            throw new SQLException("Communications link failure\n\nLeader changed.", "08S01", 0);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkHa();
        return this.realConnection.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkHa();
        return this.realConnection.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkHa();
        return this.realConnection.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.realConnection.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkHa();
        this.realConnection.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.realConnection.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.checkHa();
        this.realConnection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.realConnection.rollback();
    }

    @Override
    public void close() throws SQLException {
        this.realConnection.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        XClusterNodeBasic currentLeader = this.haManager.getLeaderRef().get();
        if (currentLeader != null && !currentLeader.getTag().equals(this.leader)) {
            this.realConnection.close();
            return true;
        }
        if (this.smoothSwitchover && this.haManager.isLeaderTransferring(this.leader)) {
            this.realConnection.close();
            return true;
        }
        return this.realConnection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkHa();
        return this.realConnection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkHa();
        this.realConnection.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkHa();
        return this.realConnection.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkHa();
        this.realConnection.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkHa();
        return this.realConnection.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkHa();
        this.realConnection.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkHa();
        return this.realConnection.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkHa();
        return this.realConnection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkHa();
        this.realConnection.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkHa();
        return this.realConnection.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkHa();
        return this.realConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkHa();
        return this.realConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.realConnection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.realConnection.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.realConnection.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.realConnection.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkHa();
        return this.realConnection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkHa();
        return this.realConnection.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.realConnection.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.realConnection.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkHa();
        return this.realConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkHa();
        return this.realConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkHa();
        return this.realConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkHa();
        return this.realConnection.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkHa();
        return this.realConnection.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkHa();
        return this.realConnection.prepareStatement(sql, columnNames);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.realConnection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.realConnection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.realConnection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.realConnection.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        XClusterNodeBasic currentLeader = this.haManager.getLeaderRef().get();
        if (currentLeader != null && !currentLeader.getTag().equals(this.leader)) {
            return false;
        }
        return this.realConnection.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.realConnection.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.realConnection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.realConnection.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.realConnection.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.realConnection.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.realConnection.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkHa();
        this.realConnection.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkHa();
        return this.realConnection.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.realConnection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.realConnection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.realConnection.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.realConnection.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.realConnection.isWrapperFor(iface);
    }
}

