/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.common;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AddressDecoder {
    private final String firstTag;
    private final Map<String, InetSocketAddress> addressMap;

    public static InetSocketAddress decode(String address) {
        String[] split = (address = address.trim()).split(":");
        if (split.length != 2) {
            int endPos;
            if (1 == split.length) {
                return new InetSocketAddress(split[0], 3306);
            }
            if ('[' == address.charAt(0) && (endPos = address.indexOf(93)) != -1) {
                int portStart = address.indexOf(58, endPos + 1);
                if (portStart != -1) {
                    return new InetSocketAddress(address.substring(1, endPos), Integer.parseInt(address.substring(portStart + 1)));
                }
                return new InetSocketAddress(address.substring(1, endPos), 3306);
            }
            return new InetSocketAddress(address, 3306);
        }
        return new InetSocketAddress(split[0], Integer.parseInt(split[1]));
    }

    public AddressDecoder(String addresses) {
        String[] split;
        if (null == addresses) {
            this.firstTag = null;
            this.addressMap = Collections.emptyMap();
            return;
        }
        String firstTag = null;
        HashMap<String, InetSocketAddress> tmp = new HashMap<String, InetSocketAddress>(3);
        for (String address : split = addresses.split(",")) {
            if (null == firstTag) {
                firstTag = address;
            }
            tmp.put(address, AddressDecoder.decode(address));
        }
        this.firstTag = firstTag;
        this.addressMap = Collections.unmodifiableMap(tmp);
    }

    public String getFirstTag() {
        return this.firstTag;
    }

    public Map<String, InetSocketAddress> getAddressMap() {
        return this.addressMap;
    }
}

