/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.polardbx.common.logging;

import com.alibaba.polardbx.common.logging.Log;
import com.alibaba.polardbx.common.logging.NoLoggingImpl;
import com.alibaba.polardbx.common.logging.Resources;
import java.lang.reflect.Constructor;

public class LogFactory {
    private static Constructor logConstructor;

    private static void tryImplementation(String testClassName, String implClassName) {
        if (logConstructor != null) {
            return;
        }
        try {
            Resources.classForName(testClassName);
            Class<?> implClass = Resources.classForName(implClassName);
            logConstructor = implClass.getConstructor(String.class);
            Class declareClass = logConstructor.getDeclaringClass();
            if (!Log.class.isAssignableFrom(declareClass)) {
                logConstructor = null;
            }
            try {
                if (null != logConstructor) {
                    logConstructor.newInstance(LogFactory.class.getName());
                }
            }
            catch (Throwable t) {
                logConstructor = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Log getLog(Class clazz) {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(String loggerName) {
        try {
            return (Log)logConstructor.newInstance(loggerName);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error creating logger for logger '" + loggerName + "'.  Cause: " + t, t);
        }
    }

    public static synchronized void selectLog4JLogging() {
        try {
            Resources.classForName("org.apache.log4j.Logger");
            Class<?> implClass = Resources.classForName("com.alibaba.polardbx.common.logging.Log4jImpl");
            logConstructor = implClass.getConstructor(String.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        String logType = System.getProperty("polardbx.logType");
        if (logType != null) {
            if (logType.equalsIgnoreCase("slf4j")) {
                LogFactory.tryImplementation("org.slf4j.Logger", "com.alibaba.polardbx.common.logging.SLF4JImpl");
            } else if (logType.equalsIgnoreCase("log4j")) {
                LogFactory.tryImplementation("org.apache.log4j.Logger", "com.alibaba.polardbx.common.logging.Log4jImpl");
            } else if (logType.equalsIgnoreCase("log4j2")) {
                LogFactory.tryImplementation("org.apache.logging.log4j.Logger", "com.alibaba.polardbx.common.logging.Log4j2Impl");
            } else if (logType.equalsIgnoreCase("commonsLog")) {
                LogFactory.tryImplementation("org.apache.commons.logging.LogFactory", "com.alibaba.polardbx.common.logging.JakartaCommonsLoggingImpl");
            } else if (logType.equalsIgnoreCase("jdkLog")) {
                LogFactory.tryImplementation("java.util.logging.Logger", "com.alibaba.polardbx.common.logging.Jdk14LoggingImpl");
            }
        }
        LogFactory.tryImplementation("org.slf4j.Logger", "com.alibaba.polardbx.common.logging.SLF4JImpl");
        LogFactory.tryImplementation("org.apache.log4j.Logger", "com.alibaba.polardbx.common.logging.Log4jImpl");
        LogFactory.tryImplementation("org.apache.logging.log4j.Logger", "com.alibaba.polardbx.common.logging.Log4j2Impl");
        LogFactory.tryImplementation("org.apache.commons.logging.LogFactory", "com.alibaba.polardbx.common.logging.JakartaCommonsLoggingImpl");
        LogFactory.tryImplementation("java.util.logging.Logger", "com.alibaba.polardbx.common.logging.Jdk14LoggingImpl");
        if (logConstructor == null) {
            try {
                logConstructor = NoLoggingImpl.class.getConstructor(String.class);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }
}

