/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.easysdk.kernel.util;

import com.alipay.easysdk.kernel.AlipayConstants;
import com.google.common.base.Preconditions;
import java.io.File;

public class MultipartUtil {
    public static byte[] getEntryBoundary(String boundary) {
        return ("\r\n--" + boundary + "\r\n").getBytes();
    }

    public static byte[] getEndBoundary(String boundary) {
        return ("\r\n--" + boundary + "--\r\n").getBytes();
    }

    public static byte[] getTextEntry(String fieldName, String fieldValue) {
        String entry = "Content-Disposition:form-data;name=\"" + fieldName + "\"\r\nContent-Type:text/plain\r\n\r\n" + fieldValue;
        return entry.getBytes(AlipayConstants.DEFAULT_CHARSET);
    }

    public static byte[] getFileEntry(String fieldName, String filePath) {
        String entry = "Content-Disposition:form-data;name=\"" + fieldName + "\";filename=\"" + MultipartUtil.getFile(filePath).getName() + "\"\r\nContent-Type:application/octet-stream\r\n\r\n";
        return entry.getBytes(AlipayConstants.DEFAULT_CHARSET);
    }

    private static File getFile(String filePath) {
        File file = new File(filePath);
        Preconditions.checkArgument((boolean)file.exists(), (Object)(file.getAbsolutePath() + "\u6587\u4ef6\u4e0d\u5b58\u5728"));
        Preconditions.checkArgument((boolean)file.getName().contains("."), (Object)"\u6587\u4ef6\u540d\u5fc5\u987b\u5e26\u4e0a\u6b63\u786e\u7684\u6269\u5c55\u540d");
        return file;
    }
}

