/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.CommandCode;
import com.alipay.remoting.NamedThreadFactory;
import com.alipay.remoting.RemotingProcessor;
import com.alipay.remoting.SystemProperties;
import com.alipay.remoting.log.BoltLoggerFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ProcessorManager {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
    private ConcurrentHashMap<CommandCode, RemotingProcessor<?>> cmd2processors = new ConcurrentHashMap(4);
    private RemotingProcessor<?> defaultProcessor;
    private ExecutorService defaultExecutor;
    private int minPoolSize = SystemProperties.default_tp_min_size();
    private int maxPoolSize = SystemProperties.default_tp_max_size();
    private int queueSize = SystemProperties.default_tp_queue_size();
    private long keepAliveTime = SystemProperties.default_tp_keepalive_time();

    public ProcessorManager() {
        this.defaultExecutor = new ThreadPoolExecutor(this.minPoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.queueSize), new NamedThreadFactory("Bolt-default-executor"));
    }

    public void registerProcessor(CommandCode cmdCode, RemotingProcessor<?> processor) {
        if (this.cmd2processors.contains(cmdCode)) {
            logger.warn("Processor for cmd={} is already registered, the processor is {}, and changed to {}", new Object[]{cmdCode, this.cmd2processors.get(cmdCode).getClass().getName(), processor.getClass().getName()});
        }
        this.cmd2processors.put(cmdCode, processor);
    }

    public void registerDefaultProcessor(RemotingProcessor<?> processor) {
        if (this.defaultProcessor != null) {
            throw new IllegalStateException("The defaultProcessor has already been registered: " + this.defaultProcessor.getClass());
        }
        this.defaultProcessor = processor;
    }

    public RemotingProcessor<?> getProcessor(CommandCode cmdCode) {
        RemotingProcessor<?> processor = this.cmd2processors.get(cmdCode);
        if (processor != null) {
            return processor;
        }
        return this.defaultProcessor;
    }

    public ExecutorService getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public void registerDefaultExecutor(ExecutorService executor) {
        this.defaultExecutor = executor;
    }
}

