/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc;

import com.alipay.remoting.ResponseStatus;
import com.alipay.remoting.exception.CodecException;
import com.alipay.remoting.exception.ConnectionClosedException;
import com.alipay.remoting.exception.DeserializationException;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.exception.SerializationException;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.rpc.ResponseCommand;
import com.alipay.remoting.rpc.exception.InvokeException;
import com.alipay.remoting.rpc.exception.InvokeSendFailedException;
import com.alipay.remoting.rpc.exception.InvokeServerBusyException;
import com.alipay.remoting.rpc.exception.InvokeServerException;
import com.alipay.remoting.rpc.exception.InvokeTimeoutException;
import com.alipay.remoting.rpc.protocol.RpcResponseCommand;
import com.alipay.remoting.util.StringUtils;
import org.slf4j.Logger;

public class RpcResponseResolver {
    private static final Logger logger = BoltLoggerFactory.getLogger("RpcRemoting");

    public static Object resolveResponseObject(ResponseCommand responseCommand, String addr) throws RemotingException {
        RpcResponseResolver.preProcess(responseCommand, addr);
        if (responseCommand.getResponseStatus() == ResponseStatus.SUCCESS) {
            return RpcResponseResolver.toResponseObject(responseCommand);
        }
        String msg = "Rpc invocation exception:" + (Object)((Object)responseCommand.getResponseStatus()) + ", the address is " + addr + ", id=" + responseCommand.getId();
        logger.warn(msg);
        if (responseCommand.getCause() != null) {
            throw new InvokeException(msg, responseCommand.getCause());
        }
        throw new InvokeException(msg + ", please check the server log.");
    }

    private static void preProcess(ResponseCommand responseCommand, String addr) throws RemotingException {
        RemotingException e = null;
        String msg = null;
        if (responseCommand == null) {
            msg = "Rpc invocation timeout[responseCommand null]! the address is " + addr;
            e = new InvokeTimeoutException(msg);
        } else {
            switch (responseCommand.getResponseStatus()) {
                case TIMEOUT: {
                    msg = "Rpc invocation timeout[responseCommand TIMEOUT]! the address is " + addr;
                    e = new InvokeTimeoutException(msg);
                    break;
                }
                case CLIENT_SEND_ERROR: {
                    msg = "Rpc invocation send failed! the address is " + addr;
                    e = new InvokeSendFailedException(msg, responseCommand.getCause());
                    break;
                }
                case CONNECTION_CLOSED: {
                    msg = "Connection closed! the address is " + addr;
                    e = new ConnectionClosedException(msg);
                    break;
                }
                case SERVER_THREADPOOL_BUSY: {
                    msg = "Server thread pool busy! the address is " + addr + ", id=" + responseCommand.getId();
                    e = new InvokeServerBusyException(msg);
                    break;
                }
                case CODEC_EXCEPTION: {
                    msg = "Codec exception! the address is " + addr + ", id=" + responseCommand.getId();
                    e = new CodecException(msg);
                    break;
                }
                case SERVER_SERIAL_EXCEPTION: {
                    msg = "Server serialize response exception! the address is " + addr + ", id=" + responseCommand.getId() + ", serverSide=true";
                    e = new SerializationException(msg, true);
                    break;
                }
                case SERVER_DESERIAL_EXCEPTION: {
                    msg = "Server deserialize request exception! the address is " + addr + ", id=" + responseCommand.getId() + ", serverSide=true";
                    e = new DeserializationException(msg, true);
                    break;
                }
                case SERVER_EXCEPTION: {
                    msg = "Server exception! Please check the server log, the address is " + addr + ", id=" + responseCommand.getId();
                    RpcResponseCommand resp = (RpcResponseCommand)responseCommand;
                    if (resp.getErrorMsg() != null) {
                        msg = msg + ".ErrorMsg: " + resp.getErrorMsg();
                    }
                    resp.deserialize();
                    Object ex = resp.getResponseObject();
                    if (ex != null && ex instanceof Throwable) {
                        e = new InvokeServerException(msg, (Throwable)ex);
                        break;
                    }
                    e = new InvokeServerException(msg);
                    break;
                }
            }
        }
        if (StringUtils.isNotBlank(msg)) {
            logger.warn(msg);
        }
        if (null != e) {
            throw e;
        }
    }

    private static Object toResponseObject(ResponseCommand responseCommand) throws CodecException {
        RpcResponseCommand response = (RpcResponseCommand)responseCommand;
        response.deserialize();
        return response.getResponseObject();
    }
}

