/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.lookout.api.composite;

import com.alipay.lookout.api.Clock;
import com.alipay.lookout.api.Id;
import com.alipay.lookout.api.Registry;
import com.alipay.lookout.api.Timer;
import com.alipay.lookout.api.composite.CompositeMetric;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

class CompositeTimer
extends CompositeMetric
implements Timer {
    private final Clock clock;

    public CompositeTimer(Id id, Clock clock, Collection<Registry> registries) {
        super(id, registries);
        this.clock = clock;
    }

    protected Timer getMetric(Registry registry) {
        return registry.timer(this.id);
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        for (Registry r : this.registries) {
            this.getMetric(r).record(amount, unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Callable<T> f) throws Exception {
        long s = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable f) {
        long s = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public long count() {
        Iterator it = this.registries.iterator();
        return it.hasNext() ? this.getMetric((Registry)it.next()).count() : 0L;
    }

    @Override
    public long totalTime() {
        Iterator it = this.registries.iterator();
        return it.hasNext() ? this.getMetric((Registry)it.next()).totalTime() : 0L;
    }

    @Override
    public void buckets(long[] buckets) {
        for (Registry r : this.registries) {
            this.getMetric(r).buckets(buckets);
        }
    }
}

