/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.task.scheduler;

import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public class TimedSupervisorTask
extends TimerTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimedSupervisorTask.class);
    private final ScheduledExecutorService scheduler;
    private final ThreadPoolExecutor executor;
    private final long timeoutMillis;
    private final Runnable task;
    private String name;
    private final AtomicLong delay;
    private final long maxDelay;

    public TimedSupervisorTask(String name, ScheduledExecutorService scheduler, ThreadPoolExecutor executor, int timeout, TimeUnit timeUnit, int expBackOffBound, Runnable task) {
        this.name = name;
        this.scheduler = scheduler;
        this.executor = executor;
        this.timeoutMillis = timeUnit.toMillis(timeout);
        this.task = task;
        this.delay = new AtomicLong(this.timeoutMillis);
        this.maxDelay = this.timeoutMillis * (long)expBackOffBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Future<?> future = null;
        try {
            future = this.executor.submit(this.task);
            future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
            this.delay.set(this.timeoutMillis);
        }
        catch (TimeoutException e) {
            LOGGER.error("{} task supervisor timed out", (Object)this.name, (Object)e);
            long currentDelay = this.delay.get();
            long newDelay = Math.min(this.maxDelay, currentDelay * 2L);
            this.delay.compareAndSet(currentDelay, newDelay);
        }
        catch (RejectedExecutionException e) {
            LOGGER.error("{} task supervisor rejected the task: {}", this.name, this.task, e);
        }
        catch (Throwable e) {
            LOGGER.error("{} task supervisor threw an exception", (Object)this.name, (Object)e);
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
            this.scheduler.schedule(this, this.delay.get(), TimeUnit.MILLISECONDS);
        }
    }
}

