/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.remoting.handler;

import com.alipay.sofa.registry.common.model.ServerDataBox;
import com.alipay.sofa.registry.common.model.console.PersistenceData;
import com.alipay.sofa.registry.common.model.metaserver.FetchProvideDataRequest;
import com.alipay.sofa.registry.common.model.metaserver.ProvideData;
import com.alipay.sofa.registry.common.model.store.DataInfo;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.ChannelHandler;
import com.alipay.sofa.registry.server.meta.remoting.handler.AbstractServerHandler;
import com.alipay.sofa.registry.store.api.DBResponse;
import com.alipay.sofa.registry.store.api.DBService;
import com.alipay.sofa.registry.store.api.OperationStatus;
import com.alipay.sofa.registry.store.api.annotation.RaftReference;

public class FetchProvideDataRequestHandler
extends AbstractServerHandler<FetchProvideDataRequest> {
    private static final Logger DB_LOGGER = LoggerFactory.getLogger(FetchProvideDataRequestHandler.class, (String)"[DBService]");
    @RaftReference
    private DBService persistenceDataDBService;

    @Override
    public Object reply(Channel channel, FetchProvideDataRequest fetchProvideDataRequest) {
        try {
            DBResponse ret = this.persistenceDataDBService.get(fetchProvideDataRequest.getDataInfoId());
            if (ret == null) {
                DB_LOGGER.error("get null Data from db!");
                throw new RuntimeException("Get null Data from db!");
            }
            if (ret.getOperationStatus() == OperationStatus.SUCCESS) {
                PersistenceData data = (PersistenceData)ret.getEntity();
                String dataInfoId = DataInfo.toDataInfoId((String)data.getDataId(), (String)data.getInstanceId(), (String)data.getGroup());
                ProvideData provideData = new ProvideData(new ServerDataBox((Object)data.getData()), dataInfoId, data.getVersion());
                DB_LOGGER.info("get ProvideData {} from DB success!", (Object)provideData);
                return provideData;
            }
            if (ret.getOperationStatus() == OperationStatus.NOTFOUND) {
                ProvideData provideData = new ProvideData(null, fetchProvideDataRequest.getDataInfoId(), null);
                DB_LOGGER.warn("has not found data from DB dataInfoId:{}", (Object)fetchProvideDataRequest.getDataInfoId());
                return provideData;
            }
            DB_LOGGER.error("get Data DB status error!");
            throw new RuntimeException("Get Data DB status error!");
        }
        catch (Exception e) {
            DB_LOGGER.error("get persistence Data dataInfoId {} from db error!", (Object)fetchProvideDataRequest.getDataInfoId());
            throw new RuntimeException("Get persistence Data from db error!", e);
        }
    }

    public ChannelHandler.HandlerType getType() {
        return ChannelHandler.HandlerType.PROCESSER;
    }

    @Override
    public Class interest() {
        return FetchProvideDataRequest.class;
    }
}

