/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.xmap;

import com.alipay.sofa.common.xmap.Context;
import com.alipay.sofa.common.xmap.Resource;
import com.alipay.sofa.runtime.log.SofaLogger;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.w3c.dom.Node;

public abstract class XValueFactory {
    static final Map<Class, XValueFactory> defaultFactories = new Hashtable<Class, XValueFactory>();
    public static final XValueFactory STRING = new XValueFactory(){

        @Override
        public Object getValue(Context ctx, String value) {
            return value;
        }
    };
    public static final XValueFactory INTEGER = new XValueFactory(){

        @Override
        public Object getValue(Context ctx, String value) {
            return Integer.valueOf(value);
        }
    };
    public static final XValueFactory LONG = new XValueFactory(){

        @Override
        public Object getValue(Context ctx, String value) {
            return Long.valueOf(value);
        }
    };
    public static final XValueFactory DOUBLE = new XValueFactory(){

        @Override
        public Object getValue(Context ctx, String value) {
            return Double.valueOf(value);
        }
    };
    public static final XValueFactory FLOAT = new XValueFactory(){

        @Override
        public Object getValue(Context ctx, String value) {
            return Float.valueOf(value);
        }
    };
    public static final XValueFactory BOOLEAN = new XValueFactory(){

        @Override
        public Object getValue(Context ctx, String value) {
            return Boolean.valueOf(value);
        }
    };
    public static final XValueFactory DATE = new XValueFactory(){
        final DateFormat df = new SimpleDateFormat("dd-MM-yyyy");

        @Override
        public Object getValue(Context ctx, String value) {
            try {
                return this.df.parse(value);
            }
            catch (Exception e) {
                return null;
            }
        }
    };
    public static final XValueFactory FILE = new XValueFactory(){

        @Override
        public Object getValue(Context ctx, String value) {
            return new File(value);
        }
    };
    public static final XValueFactory URL = new XValueFactory(){

        @Override
        public Object getValue(Context ctx, String value) {
            try {
                return new URL(value);
            }
            catch (Exception e) {
                return null;
            }
        }
    };
    public static final XValueFactory CLASS = new XValueFactory(){

        @Override
        public Object getValue(Context ctx, String value) {
            try {
                return ctx.loadClass(value);
            }
            catch (Throwable t) {
                SofaLogger.error("load class error", t);
                return null;
            }
        }
    };
    public static final XValueFactory RESOURCE = new XValueFactory(){

        @Override
        public Object getValue(Context ctx, String value) {
            try {
                return new Resource(ctx.getResource(value));
            }
            catch (Throwable t) {
                SofaLogger.error("new resource error", t);
                return null;
            }
        }
    };
    public static final XValueFactory SHORT = new XValueFactory(){

        @Override
        public Object getValue(Context ctx, String value) {
            return Short.valueOf(value);
        }
    };
    public static final XValueFactory CHAR = new XValueFactory(){

        @Override
        public Object getValue(Context ctx, String value) {
            try {
                return Character.valueOf(value.toCharArray()[0]);
            }
            catch (Throwable e) {
                return null;
            }
        }
    };
    public static final XValueFactory BYTE = new XValueFactory(){

        @Override
        public Object getValue(Context ctx, String value) {
            try {
                return value.getBytes()[0];
            }
            catch (Throwable e) {
                return null;
            }
        }
    };

    public abstract Object getValue(Context var1, String var2);

    public final Object getElementValue(Context ctx, Node element, boolean trim) {
        String text = element.getTextContent();
        return this.getValue(ctx, trim ? text.trim() : text);
    }

    public final Object getAttributeValue(Context ctx, Node element, String name) {
        Node at = element.getAttributes().getNamedItem(name);
        return at != null ? this.getValue(ctx, at.getNodeValue()) : null;
    }

    public static void addFactory(Class klass, XValueFactory factory) {
        defaultFactories.put(klass, factory);
    }

    public static XValueFactory getFactory(Class type) {
        return defaultFactories.get(type);
    }

    public static Object getValue(Context ctx, Class klass, String value) {
        XValueFactory factory = defaultFactories.get(klass);
        if (factory == null) {
            return null;
        }
        return factory.getValue(ctx, value);
    }

    static {
        XValueFactory.addFactory(String.class, STRING);
        XValueFactory.addFactory(Integer.class, INTEGER);
        XValueFactory.addFactory(Long.class, LONG);
        XValueFactory.addFactory(Float.class, FLOAT);
        XValueFactory.addFactory(Double.class, DOUBLE);
        XValueFactory.addFactory(Date.class, DATE);
        XValueFactory.addFactory(Boolean.class, BOOLEAN);
        XValueFactory.addFactory(File.class, FILE);
        XValueFactory.addFactory(URL.class, URL);
        XValueFactory.addFactory(Short.class, SHORT);
        XValueFactory.addFactory(Character.class, CHAR);
        XValueFactory.addFactory(Byte.class, BYTE);
        XValueFactory.addFactory(Integer.TYPE, INTEGER);
        XValueFactory.addFactory(Long.TYPE, LONG);
        XValueFactory.addFactory(Double.TYPE, DOUBLE);
        XValueFactory.addFactory(Float.TYPE, FLOAT);
        XValueFactory.addFactory(Boolean.TYPE, BOOLEAN);
        XValueFactory.addFactory(Short.TYPE, SHORT);
        XValueFactory.addFactory(Character.TYPE, CHAR);
        XValueFactory.addFactory(Byte.TYPE, BYTE);
        XValueFactory.addFactory(Class.class, CLASS);
        XValueFactory.addFactory(Resource.class, RESOURCE);
    }
}

