/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime;

import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import java.util.concurrent.ConcurrentHashMap;

public class SofaRuntimeProperties {
    private static ConcurrentHashMap<ClassLoader, Boolean> skipJvmReferenceHealthCheckMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<ClassLoader, Boolean> disableJvmFirstMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<ClassLoader, Boolean> skipJvmSerializeMap = new ConcurrentHashMap();

    public static boolean isSkipJvmReferenceHealthCheck(SofaRuntimeContext sofaRuntimeContext) {
        return SofaRuntimeProperties.isSkipJvmReferenceHealthCheck(sofaRuntimeContext.getAppClassLoader());
    }

    public static boolean isSkipJvmReferenceHealthCheck(ClassLoader classLoader) {
        return skipJvmReferenceHealthCheckMap.get(classLoader) != null && skipJvmReferenceHealthCheckMap.get(classLoader) != false;
    }

    public static void setSkipJvmReferenceHealthCheck(ClassLoader classLoader, boolean skipJvmReferenceHealthCheck) {
        skipJvmReferenceHealthCheckMap.putIfAbsent(classLoader, skipJvmReferenceHealthCheck);
    }

    public static boolean isDisableJvmFirst(SofaRuntimeContext sofaRuntimeContext) {
        return SofaRuntimeProperties.isDisableJvmFirst(sofaRuntimeContext.getAppClassLoader());
    }

    public static boolean isDisableJvmFirst(ClassLoader classLoader) {
        return disableJvmFirstMap.get(classLoader) != null && disableJvmFirstMap.get(classLoader) != false;
    }

    public static void setDisableJvmFirst(ClassLoader classLoader, boolean disableJvmFirst) {
        disableJvmFirstMap.putIfAbsent(classLoader, disableJvmFirst);
    }

    public static void unRegisterProperties(ClassLoader classLoader) {
        skipJvmReferenceHealthCheckMap.remove(classLoader);
        disableJvmFirstMap.remove(classLoader);
        skipJvmSerializeMap.remove(classLoader);
    }

    public static Boolean isSkipJvmSerialize(ClassLoader classLoader) {
        return skipJvmSerializeMap.get(classLoader) != null && skipJvmSerializeMap.get(classLoader) != false;
    }

    public static void setSkipJvmSerialize(ClassLoader classLoader, boolean skipJvmSerialize) {
        skipJvmSerializeMap.putIfAbsent(classLoader, skipJvmSerialize);
    }
}

