/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.ark.spi.replay;

import java.util.Stack;

public class ReplayContext {
    private static final ThreadLocal<Stack<String>> moduleVersions = new ThreadLocal<Stack<String>>(){

        @Override
        protected Stack<String> initialValue() {
            return new Stack<String>();
        }
    };
    public static final String PLACEHOLDER = "__call_placeholder__";

    public static void set(String version) {
        moduleVersions.get().push(version);
    }

    public static void unset() {
        moduleVersions.get().pop();
    }

    public static String get() {
        if (moduleVersions.get().size() == 0) {
            return null;
        }
        return moduleVersions.get().peek();
    }

    public static void setPlaceHolder() {
        if (moduleVersions.get().size() != 0) {
            moduleVersions.get().push(PLACEHOLDER);
        }
    }

    public static void clearPlaceHolder() {
        if (PLACEHOLDER.equals(ReplayContext.get())) {
            moduleVersions.get().pop();
        }
    }
}

