/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.health;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.health.HttpCodeStatusMapper;
import org.springframework.boot.actuate.health.SimpleHttpCodeStatusMapper;
import org.springframework.boot.actuate.health.Status;

public class ReadinessHttpCodeStatusMapper
implements HttpCodeStatusMapper {
    private static final Map<String, Integer> DEFAULT_MAPPINGS;
    private final SimpleHttpCodeStatusMapper statusMapper;

    public ReadinessHttpCodeStatusMapper() {
        this(null);
    }

    public ReadinessHttpCodeStatusMapper(Map<String, Integer> mappings) {
        HashMap<String, Integer> mapping = new HashMap<String, Integer>(8);
        mapping.putAll(DEFAULT_MAPPINGS);
        if (mappings != null) {
            mapping.putAll(ReadinessHttpCodeStatusMapper.getUniformMappings(mappings));
        }
        this.statusMapper = new SimpleHttpCodeStatusMapper(mapping);
    }

    public int getStatusCode(Status status) {
        return this.statusMapper.getStatusCode(status);
    }

    private static Map<String, Integer> getUniformMappings(Map<String, Integer> mappings) {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : mappings.entrySet()) {
            String code = ReadinessHttpCodeStatusMapper.getUniformCode(entry.getKey());
            if (code == null) continue;
            result.putIfAbsent(code, entry.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    private static String getUniformCode(String code) {
        if (code == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < code.length(); ++i) {
            char ch = code.charAt(i);
            if (!Character.isAlphabetic(ch) && !Character.isDigit(ch)) continue;
            builder.append(Character.toLowerCase(ch));
        }
        return builder.toString();
    }

    static {
        HashMap<String, Integer> defaultMappings = new HashMap<String, Integer>(8);
        defaultMappings.put(Status.DOWN.getCode(), 503);
        defaultMappings.put(Status.OUT_OF_SERVICE.getCode(), 500);
        defaultMappings.put(Status.UNKNOWN.getCode(), 500);
        DEFAULT_MAPPINGS = ReadinessHttpCodeStatusMapper.getUniformMappings(defaultMappings);
    }
}

