/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.actuator.rpc;

import com.alipay.sofa.boot.actuator.health.ReadinessCheckCallback;
import com.alipay.sofa.rpc.boot.context.RpcStartApplicationListener;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.context.ApplicationContext;
import org.springframework.core.PriorityOrdered;

public class RpcAfterHealthCheckCallback
implements ReadinessCheckCallback,
PriorityOrdered {
    private final RpcStartApplicationListener rpcStartApplicationListener;

    public RpcAfterHealthCheckCallback(RpcStartApplicationListener rpcStartApplicationListener) {
        this.rpcStartApplicationListener = rpcStartApplicationListener;
    }

    @Override
    public Health onHealthy(ApplicationContext applicationContext) {
        Health.Builder builder = new Health.Builder();
        this.rpcStartApplicationListener.publishRpcStartEvent();
        if (this.rpcStartApplicationListener.isSuccess()) {
            return builder.status(Status.UP).build();
        }
        return builder.status(Status.DOWN).withDetail("Reason", (Object)"Rpc service start fail").build();
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

