/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.tracer;

import com.alipay.sofa.boot.autoconfigure.tracer.SofaTracerAutoConfiguration;
import com.alipay.sofa.tracer.boot.properties.SofaTracerProperties;
import com.alipay.sofa.tracer.boot.springmvc.properties.OpenTracingSpringMvcProperties;
import com.alipay.sofa.tracer.plugins.springmvc.SpringMvcSofaTracerFilter;
import com.alipay.sofa.tracer.plugins.webflux.WebfluxSofaTracerFilter;
import java.util.Collection;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.WebFilter;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OpenTracingSpringMvcProperties.class, SofaTracerProperties.class})
@ConditionalOnProperty(prefix="com.alipay.sofa.tracer.springmvc", value={"enable"}, matchIfMissing=true)
@AutoConfigureAfter(value={SofaTracerAutoConfiguration.class})
@ConditionalOnClass(value={SofaTracerProperties.class})
public class OpenTracingSpringMvcAutoConfiguration {
    private final OpenTracingSpringMvcProperties openTracingSpringProperties;

    public OpenTracingSpringMvcAutoConfiguration(OpenTracingSpringMvcProperties openTracingSpringProperties) {
        this.openTracingSpringProperties = openTracingSpringProperties;
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    @ConditionalOnClass(value={WebfluxSofaTracerFilter.class})
    public class WebfluxSofaTracerFilterConfiguration {
        @Bean
        @Order(value=-2147483638)
        public WebFilter webfluxSofaTracerFilter() {
            return new WebfluxSofaTracerFilter();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(value={SpringMvcSofaTracerFilter.class})
    public class SpringMvcDelegatingFilterProxyConfiguration {
        @Bean
        public FilterRegistrationBean springMvcDelegatingFilterProxy() {
            FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
            SpringMvcSofaTracerFilter filter = new SpringMvcSofaTracerFilter();
            filterRegistrationBean.setFilter((Filter)filter);
            List urlPatterns = OpenTracingSpringMvcAutoConfiguration.this.openTracingSpringProperties.getUrlPatterns();
            if (urlPatterns == null || urlPatterns.size() <= 0) {
                filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
            } else {
                filterRegistrationBean.setUrlPatterns((Collection)urlPatterns);
            }
            filterRegistrationBean.setName(filter.getFilterName());
            filterRegistrationBean.setAsyncSupported(true);
            filterRegistrationBean.setOrder(OpenTracingSpringMvcAutoConfiguration.this.openTracingSpringProperties.getFilterOrder());
            return filterRegistrationBean;
        }
    }
}

