/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AllConnectConnectionHolder;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.transport.ClientTransport;
import com.alipay.sofa.rpc.transport.ClientTransportConfig;
import com.alipay.sofa.rpc.transport.ClientTransportFactory;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Extension(value="elastic")
public class ElasticConnectionHolder
extends AllConnectConnectionHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticConnectionHolder.class);
    protected int elasticConnectPercent = RpcConfigs.getIntValue("consumer.connect.elastic.percent");
    protected int elasticConnectSize = RpcConfigs.getIntValue("consumer.connect.elastic.size");

    protected ElasticConnectionHolder(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap);
        this.consumerConfig = consumerBootstrap.getConsumerConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addNode(List<ProviderInfo> providerInfoList) {
        final String interfaceId = this.consumerConfig.getInterfaceId();
        int providerSize = providerInfoList.size();
        String appName = this.consumerConfig.getAppName();
        if (LOGGER.isInfoEnabled(appName)) {
            LOGGER.infoWithApp(appName, "Add provider of {}, size is : {}", interfaceId, providerSize);
        }
        if (providerSize > 0) {
            int minSynConnectSize;
            if (this.elasticConnectPercent > 0) {
                double percent = this.elasticConnectPercent >= 100 ? 1.0 : (double)this.elasticConnectPercent * 0.01;
                minSynConnectSize = Double.valueOf((double)providerInfoList.size() * percent).intValue();
            } else {
                minSynConnectSize = this.elasticConnectSize;
            }
            int threads = Math.min(10, minSynConnectSize);
            CountDownLatch latch = new CountDownLatch(minSynConnectSize);
            int connectTimeout = this.consumerConfig.getConnectTimeout();
            NamedThreadFactory namedThreadFactory = new NamedThreadFactory("CLI-CONN-" + interfaceId, true);
            ThreadPoolExecutor initPool = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(minSynConnectSize), namedThreadFactory);
            int synInitConnectProviderSize = 0;
            for (ProviderInfo providerInfo : providerInfoList) {
                if (synInitConnectProviderSize >= minSynConnectSize) break;
                ++synInitConnectProviderSize;
                this.initClientRunnable(initPool, latch, providerInfo);
            }
            try {
                int totalTimeout = (synInitConnectProviderSize % threads == 0 ? synInitConnectProviderSize / threads : synInitConnectProviderSize / threads + 1) * connectTimeout + 500;
                latch.await(totalTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.errorWithApp(appName, "Exception when add provider", e);
            }
            finally {
                initPool.shutdown();
            }
            List<ProviderInfo> asynConnectProviderInfoList = providerInfoList.subList(synInitConnectProviderSize, providerInfoList.size());
            if (!asynConnectProviderInfoList.isEmpty()) {
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, "asynConnectProviderInfoListSize:{}", asynConnectProviderInfoList.size());
                }
                ThreadPoolExecutor executorService = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(asynConnectProviderInfoList.size()), namedThreadFactory);
                for (final ProviderInfo providerInfo : asynConnectProviderInfoList) {
                    final ClientTransportConfig config = this.providerToClientConfig(providerInfo);
                    FutureTask<String> futureTask = new FutureTask<String>(new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            ClientTransport transport = ClientTransportFactory.getClientTransport(config);
                            if (ElasticConnectionHolder.this.consumerConfig.isLazy()) {
                                ElasticConnectionHolder.this.uninitializedConnections.put(providerInfo, transport);
                            } else {
                                ElasticConnectionHolder.this.initClientTransport(interfaceId, providerInfo, transport);
                            }
                            return providerInfo.getHost() + ":" + providerInfo.getPort();
                        }
                    });
                    executorService.submit(futureTask);
                }
            }
        }
    }
}

