/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.config;

import com.alipay.sofa.rpc.api.GenericService;
import com.alipay.sofa.rpc.bootstrap.Bootstraps;
import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.Router;
import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.ExceptionUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.MethodConfig;
import com.alipay.sofa.rpc.core.invoke.SofaResponseCallback;
import com.alipay.sofa.rpc.listener.ChannelListener;
import com.alipay.sofa.rpc.listener.ConsumerStateListener;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;

public class ConsumerConfig<T>
extends AbstractInterfaceConfig<T, ConsumerConfig<T>>
implements Serializable {
    private static final long serialVersionUID = 4244077707655448146L;
    protected String protocol = RpcConfigs.getStringValue("default.protocol");
    protected String directUrl;
    protected boolean generic;
    protected String invokeType = RpcConfigs.getStringValue("consumer.invokeType");
    protected int connectTimeout = RpcConfigs.getIntValue("consumer.connect.timeout");
    protected int disconnectTimeout = RpcConfigs.getIntValue("consumer.disconnect.timeout");
    protected String cluster = RpcConfigs.getStringValue("consumer.cluster");
    protected String connectionHolder = RpcConfigs.getStringValue("consumer.connectionHolder");
    protected String addressHolder = RpcConfigs.getStringValue("consumer.addressHolder");
    protected String loadBalancer = RpcConfigs.getStringValue("consumer.loadBalancer");
    protected boolean lazy = RpcConfigs.getBooleanValue("consumer.lazy");
    protected boolean sticky = RpcConfigs.getBooleanValue("consumer.sticky");
    protected boolean inJVM = RpcConfigs.getBooleanValue("consumer.inJVM");
    protected boolean check = RpcConfigs.getBooleanValue("consumer.check");
    protected int connectionNum = RpcConfigs.getIntValue("consumer.connection.num");
    protected int heartbeatPeriod = RpcConfigs.getIntValue("consumer.heartbeat.period");
    protected int reconnectPeriod = RpcConfigs.getIntValue("consumer.reconnect.period");
    protected String rejectedExecutionPolicy = RpcConfigs.getStringValue("consumer.rejected.execution.policy");
    protected List<String> router;
    protected transient List<Router> routerRef;
    protected transient SofaResponseCallback onReturn;
    protected transient List<ChannelListener> onConnect;
    protected transient List<ConsumerStateListener> onAvailable;
    protected String bootstrap;
    protected int addressWait = RpcConfigs.getIntValue("consumer.address.wait");
    protected int repeatedReferLimit = RpcConfigs.getIntValue("consumer.repeated.reference.limit");
    protected int timeout = -1;
    protected int retries = RpcConfigs.getIntValue("consumer.retries");
    protected int concurrents = RpcConfigs.getIntValue("consumer.concurrents");
    private transient ConsumerBootstrap<T> consumerBootstrap;
    private volatile transient ProviderInfoListener providerInfoListener;

    @Override
    public String buildKey() {
        return this.protocol + "://" + this.getInterfaceId() + ":" + this.uniqueId;
    }

    @Override
    public Class<?> getProxyClass() {
        block6: {
            if (this.proxyClass != null) {
                return this.proxyClass;
            }
            if (this.generic) {
                return GenericService.class;
            }
            try {
                if (StringUtils.isNotBlank(this.interfaceId)) {
                    this.proxyClass = ClassUtils.forName(this.interfaceId);
                    if (!"tri".equals(this.protocol) && !this.proxyClass.isInterface()) {
                        throw ExceptionUtils.buildRuntime("consumer.interface", this.interfaceId, "interfaceId must set interface class, not implement class");
                    }
                    break block6;
                }
                throw ExceptionUtils.buildRuntime("consumer.interface", "null", "interfaceId must be not null");
            }
            catch (RuntimeException t) {
                throw new IllegalStateException(t.getMessage(), t);
            }
        }
        return this.proxyClass;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public ConsumerConfig<T> setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getDirectUrl() {
        return this.directUrl;
    }

    public ConsumerConfig<T> setDirectUrl(String directUrl) {
        this.directUrl = directUrl;
        return this;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public ConsumerConfig<T> setGeneric(boolean generic) {
        this.generic = generic;
        return this;
    }

    public String getInvokeType() {
        return this.invokeType;
    }

    public ConsumerConfig<T> setInvokeType(String invokeType) {
        this.invokeType = invokeType;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ConsumerConfig<T> setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getDisconnectTimeout() {
        return this.disconnectTimeout;
    }

    public ConsumerConfig<T> setDisconnectTimeout(int disconnectTimeout) {
        this.disconnectTimeout = disconnectTimeout;
        return this;
    }

    public String getCluster() {
        return this.cluster;
    }

    public ConsumerConfig<T> setCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    public int getRetries() {
        return this.retries;
    }

    public ConsumerConfig<T> setRetries(int retries) {
        this.retries = retries;
        return this;
    }

    public String getConnectionHolder() {
        return this.connectionHolder;
    }

    public ConsumerConfig<T> setConnectionHolder(String connectionHolder) {
        this.connectionHolder = connectionHolder;
        return this;
    }

    public String getAddressHolder() {
        return this.addressHolder;
    }

    public ConsumerConfig<T> setAddressHolder(String addressHolder) {
        this.addressHolder = addressHolder;
        return this;
    }

    public String getLoadBalancer() {
        return this.loadBalancer;
    }

    public ConsumerConfig<T> setLoadBalancer(String loadBalancer) {
        this.loadBalancer = loadBalancer;
        return this;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public ConsumerConfig<T> setLazy(boolean lazy) {
        this.lazy = lazy;
        return this;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public ConsumerConfig<T> setSticky(boolean sticky) {
        this.sticky = sticky;
        return this;
    }

    public boolean isInJVM() {
        return this.inJVM;
    }

    public ConsumerConfig<T> setInJVM(boolean inJVM) {
        this.inJVM = inJVM;
        return this;
    }

    public boolean isCheck() {
        return this.check;
    }

    public ConsumerConfig<T> setCheck(boolean check) {
        this.check = check;
        return this;
    }

    public int getConnectionNum() {
        return this.connectionNum;
    }

    public ConsumerConfig<T> setConnectionNum(int connectionNum) {
        this.connectionNum = connectionNum;
        return this;
    }

    public int getHeartbeatPeriod() {
        return this.heartbeatPeriod;
    }

    public ConsumerConfig<T> setHeartbeatPeriod(int heartbeatPeriod) {
        this.heartbeatPeriod = heartbeatPeriod;
        return this;
    }

    public int getReconnectPeriod() {
        return this.reconnectPeriod;
    }

    public ConsumerConfig<T> setReconnectPeriod(int reconnectPeriod) {
        this.reconnectPeriod = reconnectPeriod;
        return this;
    }

    public String getRejectedExecutionPolicy() {
        return this.rejectedExecutionPolicy;
    }

    public ConsumerConfig<T> setRejectedExecutionPolicy(String rejectedExecutionPolicy) {
        this.rejectedExecutionPolicy = rejectedExecutionPolicy;
        return this;
    }

    public List<String> getRouter() {
        return this.router;
    }

    public ConsumerConfig<T> setRouter(List<String> router) {
        this.router = router;
        return this;
    }

    public List<Router> getRouterRef() {
        return this.routerRef;
    }

    public ConsumerConfig<T> setRouterRef(List<Router> routerRef) {
        this.routerRef = routerRef;
        return this;
    }

    public SofaResponseCallback getOnReturn() {
        return this.onReturn;
    }

    public ConsumerConfig<T> setOnReturn(SofaResponseCallback onReturn) {
        this.onReturn = onReturn;
        return this;
    }

    public List<ChannelListener> getOnConnect() {
        return this.onConnect;
    }

    public ConsumerConfig<T> setOnConnect(List<ChannelListener> onConnect) {
        this.onConnect = onConnect;
        return this;
    }

    public List<ConsumerStateListener> getOnAvailable() {
        return this.onAvailable;
    }

    public ConsumerConfig<T> setOnAvailable(List<ConsumerStateListener> onAvailable) {
        this.onAvailable = onAvailable;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public ConsumerConfig<T> setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public int getConcurrents() {
        return this.concurrents;
    }

    public ConsumerConfig<T> setConcurrents(int concurrents) {
        this.concurrents = concurrents;
        return this;
    }

    public String getBootstrap() {
        return this.bootstrap;
    }

    public ConsumerConfig<T> setBootstrap(String bootstrap) {
        this.bootstrap = bootstrap;
        return this;
    }

    public int getAddressWait() {
        return this.addressWait;
    }

    public ConsumerConfig<T> setAddressWait(int addressWait) {
        this.addressWait = addressWait;
        return this;
    }

    public int getRepeatedReferLimit() {
        return this.repeatedReferLimit;
    }

    public ConsumerConfig<T> setRepeatedReferLimit(int repeatedReferLimit) {
        this.repeatedReferLimit = repeatedReferLimit;
        return this;
    }

    @Override
    public boolean hasTimeout() {
        if (this.timeout > 0) {
            return true;
        }
        if (CommonUtils.isNotEmpty(this.methods)) {
            for (MethodConfig methodConfig : this.methods.values()) {
                if (methodConfig.getTimeout() == null || methodConfig.getTimeout() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasConcurrents() {
        if (this.concurrents > 0) {
            return true;
        }
        if (CommonUtils.isNotEmpty(this.methods)) {
            for (MethodConfig methodConfig : this.methods.values()) {
                if (methodConfig.getConcurrents() == null || methodConfig.getConcurrents() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public int getMethodRetries(String methodName) {
        return (Integer)this.getMethodConfigValue(methodName, "retries", this.getRetries());
    }

    public int getMethodTimeout(String methodName) {
        return (Integer)this.getMethodConfigValue(methodName, "timeout", this.getTimeout());
    }

    public SofaResponseCallback getMethodOnreturn(String methodName) {
        return (SofaResponseCallback)this.getMethodConfigValue(methodName, "onReturn", this.getOnReturn());
    }

    public String getMethodInvokeType(String methodName) {
        return (String)this.getMethodConfigValue(methodName, "invokeType", this.getInvokeType());
    }

    public T refer() {
        if (this.consumerBootstrap == null) {
            this.consumerBootstrap = Bootstraps.from(this);
        }
        return this.consumerBootstrap.refer();
    }

    public void unRefer() {
        if (this.consumerBootstrap != null) {
            this.consumerBootstrap.unRefer();
        }
    }

    public ConsumerBootstrap<T> getConsumerBootstrap() {
        return this.consumerBootstrap;
    }

    @Override
    public ConsumerConfig<T> setSerialization(String serialization) {
        this.serialization = serialization;
        return this;
    }

    public ProviderInfoListener getProviderInfoListener() {
        return this.providerInfoListener;
    }

    public ConsumerConfig<T> setProviderInfoListener(ProviderInfoListener providerInfoListener) {
        this.providerInfoListener = providerInfoListener;
        return this;
    }

    @Override
    public String getInterfaceId() {
        if (StringUtils.equals("tri", this.getProtocol())) {
            Class<?> enclosingClass = this.getProxyClass().getEnclosingClass();
            Method sofaStub = null;
            String serviceName = this.interfaceId;
            try {
                sofaStub = enclosingClass.getDeclaredMethod("getServiceName", new Class[0]);
                serviceName = (String)sofaStub.invoke(null, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return serviceName;
        }
        return this.interfaceId;
    }
}

