/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter;

import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.AbstractInterfaceConfig;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoader;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.ext.ExtensionLoaderListener;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.ExcludeFilter;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class FilterChain
implements Invoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterChain.class);
    private static final Map<String, ExtensionClass<Filter>> PROVIDER_AUTO_ACTIVES = Collections.synchronizedMap(new LinkedHashMap());
    private static final Map<String, ExtensionClass<Filter>> CONSUMER_AUTO_ACTIVES = Collections.synchronizedMap(new LinkedHashMap());
    private static final ExtensionLoader<Filter> EXTENSION_LOADER = FilterChain.buildLoader();
    private FilterInvoker invokerChain;
    private List<Filter> loadedFilters;

    private static ExtensionLoader<Filter> buildLoader() {
        ExtensionLoader<Filter> extensionLoader = ExtensionLoaderFactory.getExtensionLoader(Filter.class);
        extensionLoader.addListener(new ExtensionLoaderListener<Filter>(){

            @Override
            public void onLoad(ExtensionClass<Filter> extensionClass) {
                Class<Filter> implClass = extensionClass.getClazz();
                AutoActive autoActive = implClass.getAnnotation(AutoActive.class);
                if (autoActive != null) {
                    String alias = extensionClass.getAlias();
                    if (autoActive.providerSide()) {
                        PROVIDER_AUTO_ACTIVES.put(alias, extensionClass);
                    }
                    if (autoActive.consumerSide()) {
                        CONSUMER_AUTO_ACTIVES.put(alias, extensionClass);
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Extension of interface " + Filter.class + ", " + implClass + "(" + alias + ") will auto active");
                    }
                }
            }
        });
        return extensionLoader;
    }

    protected FilterChain(List<Filter> filters, FilterInvoker lastInvoker, AbstractInterfaceConfig config) {
        this.invokerChain = lastInvoker;
        if (CommonUtils.isNotEmpty(filters)) {
            this.loadedFilters = new LinkedList<Filter>();
            for (int i = filters.size() - 1; i >= 0; --i) {
                try {
                    Filter filter = filters.get(i);
                    if (!filter.needToLoad(this.invokerChain)) continue;
                    this.invokerChain = new FilterInvoker(filter, this.invokerChain, config);
                    this.loadedFilters.add(filter);
                    continue;
                }
                catch (SofaRpcRuntimeException e) {
                    LOGGER.error(LogCodes.getLog("010030003"), e);
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.error(LogCodes.getLog("010030003"), e);
                    throw new SofaRpcRuntimeException(LogCodes.getLog("010030003"), e);
                }
            }
        }
    }

    public static FilterChain buildProviderChain(ProviderConfig<?> providerConfig, FilterInvoker lastFilter) {
        return new FilterChain(FilterChain.selectActualFilters(providerConfig, PROVIDER_AUTO_ACTIVES), lastFilter, providerConfig);
    }

    public static FilterChain buildConsumerChain(ConsumerConfig<?> consumerConfig, FilterInvoker lastFilter) {
        return new FilterChain(FilterChain.selectActualFilters(consumerConfig, CONSUMER_AUTO_ACTIVES), lastFilter, consumerConfig);
    }

    private static List<Filter> selectActualFilters(AbstractInterfaceConfig config, Map<String, ExtensionClass<Filter>> autoActiveFilters) {
        ArrayList<Filter> customFilters = config.getFilterRef() == null ? new ArrayList() : new CopyOnWriteArrayList<Filter>(config.getFilterRef());
        HashSet<String> excludes = FilterChain.parseExcludeFilter(customFilters);
        LinkedList<ExtensionClass> extensionFilters = new LinkedList<ExtensionClass>();
        List<String> filterAliases = config.getFilter();
        if (CommonUtils.isNotEmpty(filterAliases)) {
            for (String string : filterAliases) {
                if (FilterChain.startsWithExcludePrefix(string)) {
                    excludes.add(string.substring(1));
                    continue;
                }
                ExtensionClass<Filter> filter = EXTENSION_LOADER.getExtensionClass(string);
                if (filter == null) continue;
                extensionFilters.add(filter);
            }
        }
        if (!excludes.contains("*") && !excludes.contains("default")) {
            for (Map.Entry entry : autoActiveFilters.entrySet()) {
                if (excludes.contains(entry.getKey())) continue;
                extensionFilters.add((ExtensionClass)entry.getValue());
            }
        }
        if (extensionFilters.size() > 1) {
            extensionFilters.sort(Comparator.comparingInt(ExtensionClass::getOrder));
        }
        ArrayList<Filter> actualFilters = new ArrayList<Filter>();
        for (ExtensionClass extensionFilter : extensionFilters) {
            actualFilters.add((Filter)extensionFilter.getExtInstance());
        }
        actualFilters.addAll(customFilters);
        return actualFilters;
    }

    private static HashSet<String> parseExcludeFilter(List<Filter> customFilters) {
        HashSet<String> excludeKeys = new HashSet<String>();
        if (CommonUtils.isNotEmpty(customFilters)) {
            for (Filter filter : customFilters) {
                if (!(filter instanceof ExcludeFilter)) continue;
                ExcludeFilter excludeFilter = (ExcludeFilter)filter;
                String excludeName = excludeFilter.getExcludeName();
                if (StringUtils.isNotEmpty(excludeName)) {
                    String excludeFilterName;
                    String string = excludeFilterName = FilterChain.startsWithExcludePrefix(excludeName) ? excludeName.substring(1) : excludeName;
                    if (StringUtils.isNotEmpty(excludeFilterName)) {
                        excludeKeys.add(excludeFilterName);
                    }
                }
                customFilters.remove(filter);
            }
        }
        if (!excludeKeys.isEmpty() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Find exclude filters: {}", excludeKeys);
        }
        return excludeKeys;
    }

    private static boolean startsWithExcludePrefix(String excludeName) {
        char c = excludeName.charAt(0);
        return c == '-' || c == '!';
    }

    @Override
    public SofaResponse invoke(SofaRequest sofaRequest) throws SofaRpcException {
        return this.invokerChain.invoke(sofaRequest);
    }

    public void onAsyncResponse(ConsumerConfig config, SofaRequest request, SofaResponse response, Throwable throwable) throws SofaRpcException {
        try {
            for (Filter loadedFilter : this.loadedFilters) {
                loadedFilter.onAsyncResponse(config, request, response, throwable);
            }
        }
        catch (SofaRpcException e) {
            LOGGER.errorWithApp(config.getAppName(), "Catch exception when do filtering after asynchronous respond.", e);
        }
    }

    protected Invoker getChain() {
        return this.invokerChain;
    }
}

