/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.tracer.sofatracer.factory;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.reporter.facade.AbstractReporter;
import com.alipay.common.tracer.core.reporter.stat.SofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.reporter.stat.model.StatValues;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.tracer.sofatracer.log.digest.RpcClientDigestSpanJsonEncoder;
import com.alipay.sofa.rpc.tracer.sofatracer.log.digest.RpcServerDigestSpanJsonEncoder;
import io.opentracing.Span;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MemoryReporterImpl
extends AbstractReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryReporterImpl.class);
    private SofaTracerStatisticReporter statReporter;
    private Map<StatKey, StatValues> storeDatas = new HashMap<StatKey, StatValues>();
    private SpanEncoder clientDigestEncoder = new RpcClientDigestSpanJsonEncoder();
    private SpanEncoder serverDigestEncoder = new RpcServerDigestSpanJsonEncoder();
    private static List<String> clientDigestHolder = new ArrayList<String>();
    private static List<String> serverDigestHolder = new ArrayList<String>();
    private static Lock lock = new ReentrantLock();

    public MemoryReporterImpl(String digestLog, String digestRollingPolicy, String digestLogReserveConfig, SpanEncoder<SofaTracerSpan> spanEncoder, SofaTracerStatisticReporter statReporter) {
        this.statReporter = statReporter;
    }

    public void doReport(SofaTracerSpan span) {
        lock.lock();
        if (span.isClient()) {
            try {
                String result = this.clientDigestEncoder.encode((Span)span);
                clientDigestHolder.add(result);
            }
            catch (IOException e) {
                LOGGER.error("encode error", e);
            }
        } else {
            try {
                String result = this.serverDigestEncoder.encode((Span)span);
                serverDigestHolder.add(result);
            }
            catch (IOException e) {
                LOGGER.error("encode error", e);
            }
        }
        if (this.statReporter != null) {
            this.statisticReport(span);
        }
        lock.unlock();
    }

    public String getReporterType() {
        return "Memory";
    }

    private void statisticReport(SofaTracerSpan span) {
        this.statReporter.reportStat(span);
        Map datas = null;
        try {
            Field statDatas = MemoryReporterImpl.getDeclaredField(this.statReporter, "statDatas");
            statDatas.setAccessible(true);
            datas = (Map)statDatas.get(this.statReporter);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("statisticReport error", e);
        }
        this.storeDatas.putAll(datas);
    }

    public List<String> getClientDigestHolder() {
        return clientDigestHolder;
    }

    public List<String> getServerDigestHolder() {
        return serverDigestHolder;
    }

    public Map<StatKey, StatValues> getStoreDatas() {
        return this.storeDatas;
    }

    public static Field getDeclaredField(Object object, String fieldName) {
        Field field = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }

    public boolean clearAll() {
        clientDigestHolder.clear();
        serverDigestHolder.clear();
        return true;
    }
}

