/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.utils;

import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class SofaProtoUtils {
    public static boolean isProtoClass(Object object) {
        return object instanceof BindableService;
    }

    public static Set<String> getMethodNames(String interfaceId) {
        Method[] methods;
        HashSet<String> result = new HashSet<String>();
        Class interfaceClass = ClassUtils.forName(interfaceId);
        for (Method method : methods = interfaceClass.getMethods()) {
            result.add(method.getName());
        }
        return result;
    }

    public static boolean checkIfUseGeneric(ConsumerConfig consumerConfig) {
        Class<?> proxyClass = consumerConfig.getProxyClass();
        Class<?> enclosingClass = proxyClass.getEnclosingClass();
        if (enclosingClass != null) {
            try {
                enclosingClass.getDeclaredMethod("getSofaStub", Channel.class, CallOptions.class, Integer.TYPE);
                return false;
            }
            catch (NoSuchMethodException e) {
                return true;
            }
        }
        return true;
    }
}

