/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.datasource;

import com.alipay.common.tracer.core.utils.StringUtils;
import com.alipay.sofa.tracer.plugins.datasource.BaseDataSource;
import com.alipay.sofa.tracer.plugins.datasource.DBType;
import com.alipay.sofa.tracer.plugins.datasource.Interceptor;
import com.alipay.sofa.tracer.plugins.datasource.Prop;
import com.alipay.sofa.tracer.plugins.datasource.tracer.ConnectionTraceInterceptor;
import com.alipay.sofa.tracer.plugins.datasource.tracer.DataSourceClientTracer;
import com.alipay.sofa.tracer.plugins.datasource.tracer.Endpoint;
import com.alipay.sofa.tracer.plugins.datasource.tracer.KeyValueAnnotation;
import com.alipay.sofa.tracer.plugins.datasource.tracer.StatementTracerInterceptor;
import com.alipay.sofa.tracer.plugins.datasource.utils.DataSourceUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;

public class SmartDataSource
extends BaseDataSource {
    private String appName;
    private String database;
    private String dbType;
    private boolean isEnableTrace = Boolean.TRUE;
    private DataSourceClientTracer clientTracer = DataSourceClientTracer.getDataSourceClientTracer();
    protected final List<KeyValueAnnotation> traceAnnotations = new ArrayList<KeyValueAnnotation>();

    public SmartDataSource() {
        this(null);
    }

    public SmartDataSource(DataSource delegate) {
        super(delegate);
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public boolean isEnableTrace() {
        return this.isEnableTrace;
    }

    public void setEnableTrace(boolean enableTrace) {
        this.isEnableTrace = enableTrace;
    }

    public DataSourceClientTracer getClientTracer() {
        return this.clientTracer;
    }

    public void setClientTracer(DataSourceClientTracer clientTracer) {
        this.clientTracer = clientTracer;
    }

    public List<KeyValueAnnotation> getTraceAnnotations() {
        return this.traceAnnotations;
    }

    @Override
    public void init() {
        if (this.initialized.compareAndSet(false, true)) {
            if (StringUtils.isBlank((String)this.dbType)) {
                throw new IllegalArgumentException("dbType must not be null or empty");
            }
            String upperDbType = this.dbType.toUpperCase();
            if (!DBType.supportedDbTypes.containsKey(upperDbType)) {
                throw new IllegalArgumentException("dbType: " + upperDbType + "not in support list: " + DBType.supportedDbTypes);
            }
            this.traceAnnotations.add(new KeyValueAnnotation("database.type", this.dbType));
            if (StringUtils.isBlank((String)this.database)) {
                throw new IllegalArgumentException("database must not be null or empty");
            }
            this.traceAnnotations.add(new KeyValueAnnotation("database.name", this.database));
            if (StringUtils.isBlank((String)this.appName)) {
                throw new IllegalArgumentException("appName must not be null or empty");
            }
            this.traceAnnotations.add(new KeyValueAnnotation("local.app", this.appName));
            DataSource dataSource = this.getDelegate();
            String jdbcUrl = DataSourceUtils.getJdbcUrl(dataSource);
            Endpoint endpoint = DataSourceUtils.getEndpointFromConnectionURL(jdbcUrl);
            this.traceAnnotations.add(new KeyValueAnnotation("database.endpoint", endpoint.getEndpoint()));
            Prop prop = this.getProp();
            List<Interceptor> interceptors = this.getInterceptors();
            if (interceptors != null && !interceptors.isEmpty()) {
                prop.addAll(interceptors);
            }
            if (this.isEnableTrace && this.clientTracer != null) {
                this.setupStatementTracerInterceptor();
                this.setupConnectionTracerInterceptor();
            }
        }
    }

    protected void setupStatementTracerInterceptor() {
        StatementTracerInterceptor statementTracerInterceptor = new StatementTracerInterceptor();
        statementTracerInterceptor.setClientTracer(this.clientTracer);
        this.getProp().addInterceptor(statementTracerInterceptor);
    }

    protected void setupConnectionTracerInterceptor() {
        List<Interceptor> dataSourceInterceptors = this.getDataSourceInterceptors();
        ConnectionTraceInterceptor connectionTraceInterceptor = new ConnectionTraceInterceptor(this.traceAnnotations);
        if (dataSourceInterceptors != null) {
            dataSourceInterceptors.add(connectionTraceInterceptor);
        } else {
            this.setDataSourceInterceptors(Collections.singletonList(connectionTraceInterceptor));
        }
    }
}

