/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.datasource.tracer;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.context.trace.SofaTraceContext;
import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractClientTracer;
import com.alipay.sofa.tracer.plugins.datasource.tracer.DataSourceClientDigestEncoder;
import com.alipay.sofa.tracer.plugins.datasource.tracer.DataSourceClientDigestJsonEncoder;
import com.alipay.sofa.tracer.plugins.datasource.tracer.DataSourceClientStatJsonReporter;
import com.alipay.sofa.tracer.plugins.datasource.tracer.DataSourceClientStatReporter;
import com.alipay.sofa.tracer.plugins.datasource.tracer.DataSourceLogEnum;
import com.alipay.sofa.tracer.plugins.datasource.tracer.DataSourceTracerState;
import com.alipay.sofa.tracer.plugins.datasource.utils.SqlUtils;

public class DataSourceClientTracer
extends AbstractClientTracer {
    private static final ThreadLocal<DataSourceTracerState> traceState = new ThreadLocal<DataSourceTracerState>(){

        @Override
        protected DataSourceTracerState initialValue() {
            return null;
        }
    };
    private static volatile DataSourceClientTracer dataSourceClientTracer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DataSourceClientTracer getDataSourceClientTracer() {
        if (dataSourceClientTracer != null) return dataSourceClientTracer;
        Class<DataSourceClientTracer> clazz = DataSourceClientTracer.class;
        synchronized (DataSourceClientTracer.class) {
            if (dataSourceClientTracer != null) return dataSourceClientTracer;
            dataSourceClientTracer = new DataSourceClientTracer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dataSourceClientTracer;
        }
    }

    private DataSourceClientTracer() {
        super("dataSource");
    }

    protected String getClientDigestReporterLogName() {
        return DataSourceLogEnum.DATA_SOURCE_CLIENT_DIGEST.getDefaultLogName();
    }

    protected String getClientDigestReporterRollingKey() {
        return DataSourceLogEnum.DATA_SOURCE_CLIENT_DIGEST.getRollingKey();
    }

    protected String getClientDigestReporterLogNameKey() {
        return DataSourceLogEnum.DATA_SOURCE_CLIENT_DIGEST.getLogNameKey();
    }

    protected SpanEncoder<SofaTracerSpan> getClientDigestEncoder() {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new DataSourceClientDigestJsonEncoder();
        }
        return new DataSourceClientDigestEncoder();
    }

    protected AbstractSofaTracerStatisticReporter generateClientStatReporter() {
        DataSourceLogEnum dataSourceLogEnum = DataSourceLogEnum.DATA_SOURCE_CLIENT_STAT;
        String statLogName = dataSourceLogEnum.getDefaultLogName();
        String statRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)dataSourceLogEnum.getRollingKey());
        String statLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)dataSourceLogEnum.getLogNameKey());
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new DataSourceClientStatJsonReporter(statLogName, statRollingPolicy, statLogReserveConfig);
        }
        return new DataSourceClientStatReporter(statLogName, statRollingPolicy, statLogReserveConfig);
    }

    public void startTrace(String sql) {
        long startTime = System.currentTimeMillis();
        SofaTracerSpan sofaTracerSpan = this.clientSend((String)this.getStateValue("database.name"));
        SofaTracerSpanContext cxt = sofaTracerSpan.getSofaTracerSpanContext();
        if (cxt != null) {
            this.propagate();
            if (this.isProcessingFirstSql()) {
                sofaTracerSpan.setStartTime(startTime);
                sofaTracerSpan.setTag("connection.establish.span", (Number)((Long)this.getStateValue("connection.establish.span")));
            } else {
                sofaTracerSpan.setStartTime(startTime);
                sofaTracerSpan.setTag("connection.establish.span", (Number)0L);
            }
            sofaTracerSpan.setTag("local.app", (String)this.getStateValue("local.app"));
            sofaTracerSpan.setTag("database.type", (String)this.getStateValue("database.type"));
            sofaTracerSpan.setTag("database.name", (String)this.getStateValue("database.name"));
            sofaTracerSpan.setTag("database.endpoint", (String)this.getStateValue("database.endpoint"));
            sofaTracerSpan.setTag("sql", SqlUtils.getSqlEscaped(sql));
        }
    }

    public void endTrace(long cost, String resultCode) {
        SofaTracerSpan sofaTracerSpan;
        SofaTraceContext sofaTraceContext = SofaTraceContextHolder.getSofaTraceContext();
        if (sofaTraceContext != null && (sofaTracerSpan = sofaTraceContext.getCurrentSpan()) != null) {
            sofaTracerSpan.setTag("db.execute.cost", (Number)cost);
            try {
                sofaTracerSpan.setTag("result.code", resultCode);
                sofaTracerSpan.setEndTime(System.currentTimeMillis());
                this.clientReceive(resultCode);
            }
            catch (Throwable throwable) {
                SelfLog.errorWithTraceId((String)"db processed", (Throwable)throwable);
            }
        }
    }

    protected void propagate() {
        DataSourceTracerState state = traceState.get();
        if (state != null) {
            state.propagate();
        }
    }

    protected boolean isProcessingFirstSql() {
        DataSourceTracerState state = traceState.get();
        return state == null || state.isProcessingFirstSql();
    }

    protected Object getStateValue(String key) {
        DataSourceTracerState state = traceState.get();
        if (state != null) {
            return state.getValue(key);
        }
        return null;
    }

    public static DataSourceTracerState newState() {
        DataSourceTracerState state = new DataSourceTracerState();
        traceState.set(state);
        return state;
    }
}

