/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugin.flexible;

import com.alipay.common.tracer.core.appender.builder.JsonStringBuilder;
import com.alipay.common.tracer.core.appender.builder.XStringBuilder;
import com.alipay.common.tracer.core.middleware.parent.AbstractDigestSpanEncoder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import io.opentracing.tag.Tags;
import java.util.Map;
import java.util.Set;

public class FlexibleDigestJsonEncoder
extends AbstractDigestSpanEncoder {
    protected void appendComponentSlot(XStringBuilder xsb, JsonStringBuilder jsb, SofaTracerSpan span) {
        Map strTags = span.getTagsWithStr();
        Map numTags = span.getTagsWithNumber();
        Map boolTags = span.getTagsWithBool();
        jsb.append("method", strTags.get("method"));
        Set strKeys = strTags.keySet();
        strKeys.forEach(key -> {
            if (!this.isFlexible((String)key)) {
                jsb.append(key, strTags.get(key));
            }
        });
        Set numKeys = numTags.keySet();
        numKeys.forEach(key -> {
            if (!this.isFlexible((String)key)) {
                jsb.append(key, numTags.get(key));
            }
        });
        Set boolKeys = boolTags.keySet();
        boolKeys.forEach(key -> {
            if (!this.isFlexible((String)key)) {
                jsb.append(key, boolTags.get(key));
            }
        });
    }

    protected boolean isFlexible(String key) {
        return "local.app".equalsIgnoreCase(key) || "traceId".equalsIgnoreCase(key) || "spanId".equalsIgnoreCase(key) || "current.thread.name".equalsIgnoreCase(key) || "method".equalsIgnoreCase(key) || "time".equalsIgnoreCase(key) || "time.cost.milliseconds".equalsIgnoreCase(key) || Tags.SPAN_KIND.getKey().equalsIgnoreCase(key);
    }
}

