/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.gateway.pop;

import com.aliyun.darabonba.encode.Encoder;
import com.aliyun.darabonba.signature.Signer;
import com.aliyun.gateway.spi.models.AttributeMap;
import com.aliyun.gateway.spi.models.InterceptorContext;
import com.aliyun.tea.Tea;
import com.aliyun.tea.TeaConverter;
import com.aliyun.tea.TeaException;
import com.aliyun.tea.TeaPair;
import com.aliyun.teautil.Common;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class Client
extends com.aliyun.gateway.spi.Client {
    public String _sha256 = "ACS4-HMAC-SHA256";
    public String _sm3 = "ACS4-HMAC-SM3";

    public void modifyConfiguration(InterceptorContext context, AttributeMap attributeMap) throws Exception {
        InterceptorContext.InterceptorContextRequest request = context.request;
        InterceptorContext.InterceptorContextConfiguration config = context.configuration;
        config.endpoint = this.getEndpoint(request.productId, config.regionId, config.endpointRule, config.network, config.suffix, config.endpointMap, config.endpoint);
    }

    public void modifyRequest(InterceptorContext context, AttributeMap attributeMap) throws Exception {
        InterceptorContext.InterceptorContextRequest request = context.request;
        InterceptorContext.InterceptorContextConfiguration config = context.configuration;
        String date = com.aliyun.openapiutil.Client.getTimestamp();
        request.headers = TeaConverter.merge(String.class, (Map[])new Map[]{TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("host", (Object)config.endpoint), new TeaPair("x-acs-version", (Object)request.version), new TeaPair("x-acs-action", (Object)request.action), new TeaPair("user-agent", (Object)request.userAgent), new TeaPair("x-acs-date", (Object)date), new TeaPair("x-acs-signature-nonce", (Object)Common.getNonce()), new TeaPair("accept", (Object)"application/json")}), request.headers});
        String signatureAlgorithm = Common.defaultString((String)request.signatureAlgorithm, (String)this._sha256);
        String hashedRequestPayload = Encoder.hexEncode((byte[])Encoder.hash((byte[])Common.toBytes((String)""), (String)signatureAlgorithm));
        if (!Common.isUnset((Object)request.stream)) {
            byte[] tmp = Common.readAsBytes((InputStream)request.stream);
            hashedRequestPayload = Encoder.hexEncode((byte[])Encoder.hash((byte[])tmp, (String)signatureAlgorithm));
            request.stream = Tea.toReadable((byte[])tmp);
            request.headers.put("content-type", "application/octet-stream");
        } else if (!Common.isUnset((Object)request.body)) {
            if (Common.equalString((String)request.reqBodyType, (String)"json")) {
                String jsonObj = Common.toJSONString((Object)request.body);
                hashedRequestPayload = Encoder.hexEncode((byte[])Encoder.hash((byte[])Common.toBytes((String)jsonObj), (String)signatureAlgorithm));
                request.stream = Tea.toReadable((String)jsonObj);
                request.headers.put("content-type", "application/json; charset=utf-8");
            } else {
                Map m = Common.assertAsMap((Object)request.body);
                String formObj = com.aliyun.openapiutil.Client.toForm((Map)m);
                hashedRequestPayload = Encoder.hexEncode((byte[])Encoder.hash((byte[])Common.toBytes((String)formObj), (String)signatureAlgorithm));
                request.stream = Tea.toReadable((String)formObj);
                request.headers.put("content-type", "application/x-www-form-urlencoded");
            }
        }
        if (Common.equalString((String)signatureAlgorithm, (String)this._sm3)) {
            request.headers.put("x-acs-content-sm3", hashedRequestPayload);
        } else {
            request.headers.put("x-acs-content-sha256", hashedRequestPayload);
        }
        if (!Common.equalString((String)request.authType, (String)"Anonymous")) {
            com.aliyun.credentials.Client credential = request.credential;
            if (Common.isUnset((Object)credential)) {
                throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)"ParameterMissing"), new TeaPair("message", (Object)"'config.credential' can not be unset")}));
            }
            String authType = credential.getType();
            if (Common.equalString((String)authType, (String)"bearer")) {
                String bearerToken = credential.getBearerToken();
                request.headers.put("x-acs-bearer-token", bearerToken);
                request.headers.put("Authorization", "Bearer " + bearerToken + "");
            } else {
                String accessKeyId = credential.getAccessKeyId();
                String accessKeySecret = credential.getAccessKeySecret();
                String securityToken = credential.getSecurityToken();
                if (!Common.empty((String)securityToken)) {
                    request.headers.put("x-acs-accesskey-id", accessKeyId);
                    request.headers.put("x-acs-security-token", securityToken);
                }
                String dateNew = com.aliyun.darabonbastring.Client.subString((String)date, (Integer)0, (Integer)10);
                dateNew = com.aliyun.darabonbastring.Client.replace((String)dateNew, (String)"-", (String)"", null);
                String region = this.getRegion(request.productId, config.endpoint);
                byte[] signingkey = this.getSigningkey(signatureAlgorithm, accessKeySecret, request.productId, region, dateNew);
                request.headers.put("Authorization", this.getAuthorization(request.pathname, request.method, request.query, request.headers, signatureAlgorithm, hashedRequestPayload, accessKeyId, signingkey, request.productId, region, dateNew));
            }
        }
    }

    public void modifyResponse(InterceptorContext context, AttributeMap attributeMap) throws Exception {
        InterceptorContext.InterceptorContextRequest request = context.request;
        InterceptorContext.InterceptorContextResponse response = context.response;
        if (Common.is4xx((Number)response.statusCode) || Common.is5xx((Number)response.statusCode)) {
            Object _res = Common.readAsJSON((InputStream)response.body);
            Map err = Common.assertAsMap((Object)_res);
            Object requestId = this.defaultAny(err.get("RequestId"), err.get("requestId"));
            if (!Common.isUnset(response.headers.get("x-acs-request-id"))) {
                requestId = response.headers.get("x-acs-request-id");
            }
            err.put("statusCode", response.statusCode);
            throw new TeaException(TeaConverter.buildMap((TeaPair[])new TeaPair[]{new TeaPair("code", (Object)("" + this.defaultAny(err.get("Code"), err.get("code")) + "")), new TeaPair("message", (Object)("code: " + response.statusCode + ", " + this.defaultAny(err.get("Message"), err.get("message")) + " request id: " + requestId + "")), new TeaPair("data", (Object)err), new TeaPair("description", (Object)("" + this.defaultAny(err.get("Description"), err.get("description")) + "")), new TeaPair("accessDeniedDetail", this.defaultAny(err.get("AccessDeniedDetail"), err.get("accessDeniedDetail")))}));
        }
        if (Common.equalNumber((Number)response.statusCode, (Number)204)) {
            Common.readAsString((InputStream)response.body);
        } else if (Common.equalString((String)request.bodyType, (String)"binary")) {
            response.deserializedBody = response.body;
        } else if (Common.equalString((String)request.bodyType, (String)"byte")) {
            byte[] byt = Common.readAsBytes((InputStream)response.body);
            response.deserializedBody = byt;
        } else if (Common.equalString((String)request.bodyType, (String)"string")) {
            String str = Common.readAsString((InputStream)response.body);
            response.deserializedBody = str;
        } else if (Common.equalString((String)request.bodyType, (String)"json")) {
            Object obj = Common.readAsJSON((InputStream)response.body);
            Map res = Common.assertAsMap((Object)obj);
            response.deserializedBody = res;
        } else {
            Object arr;
            response.deserializedBody = Common.equalString((String)request.bodyType, (String)"array") ? (arr = Common.readAsJSON((InputStream)response.body)) : Common.readAsString((InputStream)response.body);
        }
    }

    public String getEndpoint(String productId, String regionId, String endpointRule, String network, String suffix, Map<String, String> endpointMap, String endpoint) throws Exception {
        if (!Common.empty((String)endpoint)) {
            return endpoint;
        }
        if (!Common.isUnset(endpointMap) && !Common.empty((String)endpointMap.get(regionId))) {
            return endpointMap.get(regionId);
        }
        return com.aliyun.endpointutil.Client.getEndpointRules((String)productId, (String)regionId, (String)endpointRule, (String)network, (String)suffix);
    }

    public Object defaultAny(Object inputValue, Object defaultValue) throws Exception {
        if (Common.isUnset((Object)inputValue)) {
            return defaultValue;
        }
        return inputValue;
    }

    public String getAuthorization(String pathname, String method, Map<String, String> query, Map<String, String> headers, String signatureAlgorithm, String payload, String ak, byte[] signingkey, String product, String region, String date) throws Exception {
        String signature = this.getSignature(pathname, method, query, headers, signatureAlgorithm, payload, signingkey);
        List<String> signedHeaders = this.getSignedHeaders(headers);
        String signedHeadersStr = com.aliyun.darabonba.array.Client.join(signedHeaders, (String)";");
        return "" + signatureAlgorithm + " Credential=" + ak + "/" + date + "/" + region + "/" + product + "/aliyun_v4_request,SignedHeaders=" + signedHeadersStr + ",Signature=" + signature + "";
    }

    public String getSignature(String pathname, String method, Map<String, String> query, Map<String, String> headers, String signatureAlgorithm, String payload, byte[] signingkey) throws Exception {
        String canonicalURI = "/";
        if (!Common.empty((String)pathname)) {
            canonicalURI = pathname;
        }
        String stringToSign = "";
        String canonicalizedResource = this.buildCanonicalizedResource(query);
        String canonicalizedHeaders = this.buildCanonicalizedHeaders(headers);
        List<String> signedHeaders = this.getSignedHeaders(headers);
        String signedHeadersStr = com.aliyun.darabonba.array.Client.join(signedHeaders, (String)";");
        stringToSign = "" + method + "\n" + canonicalURI + "\n" + canonicalizedResource + "\n" + canonicalizedHeaders + "\n" + signedHeadersStr + "\n" + payload + "";
        String hex = Encoder.hexEncode((byte[])Encoder.hash((byte[])Common.toBytes((String)stringToSign), (String)signatureAlgorithm));
        stringToSign = "" + signatureAlgorithm + "\n" + hex + "";
        byte[] signature = Common.toBytes((String)"");
        if (Common.equalString((String)signatureAlgorithm, (String)this._sha256)) {
            signature = Signer.HmacSHA256SignByBytes((String)stringToSign, (byte[])signingkey);
        } else if (Common.equalString((String)signatureAlgorithm, (String)this._sm3)) {
            signature = Signer.HmacSM3SignByBytes((String)stringToSign, (byte[])signingkey);
        }
        return Encoder.hexEncode((byte[])signature);
    }

    public byte[] getSigningkey(String signatureAlgorithm, String secret, String product, String region, String date) throws Exception {
        String sc1 = "aliyun_v4" + secret + "";
        byte[] sc2 = Common.toBytes((String)"");
        if (Common.equalString((String)signatureAlgorithm, (String)this._sha256)) {
            sc2 = Signer.HmacSHA256Sign((String)date, (String)sc1);
        } else if (Common.equalString((String)signatureAlgorithm, (String)this._sm3)) {
            sc2 = Signer.HmacSM3Sign((String)date, (String)sc1);
        }
        byte[] sc3 = Common.toBytes((String)"");
        if (Common.equalString((String)signatureAlgorithm, (String)this._sha256)) {
            sc3 = Signer.HmacSHA256SignByBytes((String)region, (byte[])sc2);
        } else if (Common.equalString((String)signatureAlgorithm, (String)this._sm3)) {
            sc3 = Signer.HmacSM3SignByBytes((String)region, (byte[])sc2);
        }
        byte[] sc4 = Common.toBytes((String)"");
        if (Common.equalString((String)signatureAlgorithm, (String)this._sha256)) {
            sc4 = Signer.HmacSHA256SignByBytes((String)product, (byte[])sc3);
        } else if (Common.equalString((String)signatureAlgorithm, (String)this._sm3)) {
            sc4 = Signer.HmacSM3SignByBytes((String)product, (byte[])sc3);
        }
        byte[] hmac = Common.toBytes((String)"");
        if (Common.equalString((String)signatureAlgorithm, (String)this._sha256)) {
            hmac = Signer.HmacSHA256SignByBytes((String)"aliyun_v4_request", (byte[])sc4);
        } else if (Common.equalString((String)signatureAlgorithm, (String)this._sm3)) {
            hmac = Signer.HmacSM3SignByBytes((String)"aliyun_v4_request", (byte[])sc4);
        }
        return hmac;
    }

    public String getRegion(String product, String endpoint) throws Exception {
        String region = "center";
        if (Common.empty((String)product) || Common.empty((String)endpoint)) {
            return region;
        }
        String preRegion = com.aliyun.darabonbastring.Client.replace((String)endpoint, (String)".aliyuncs.com", (String)"", null);
        List nodes = com.aliyun.darabonbastring.Client.split((String)preRegion, (String)".", null);
        if (Common.equalNumber((Number)com.aliyun.darabonba.array.Client.size((List)nodes), (Number)2)) {
            region = (String)nodes.get(1);
        }
        return region;
    }

    public String buildCanonicalizedResource(Map<String, String> query) throws Exception {
        String canonicalizedResource = "";
        if (!Common.isUnset(query)) {
            List queryArray = com.aliyun.darabonba.map.Client.keySet(query);
            List sortedQueryArray = com.aliyun.darabonba.array.Client.ascSort((List)queryArray);
            String separator = "";
            for (String key : sortedQueryArray) {
                canonicalizedResource = "" + canonicalizedResource + "" + separator + "" + Encoder.percentEncode((String)key) + "";
                if (!Common.empty((String)query.get(key))) {
                    canonicalizedResource = "" + canonicalizedResource + "=" + Encoder.percentEncode((String)query.get(key)) + "";
                }
                separator = "&";
            }
        }
        return canonicalizedResource;
    }

    public String buildCanonicalizedHeaders(Map<String, String> headers) throws Exception {
        String canonicalizedHeaders = "";
        List<String> sortedHeaders = this.getSignedHeaders(headers);
        for (String header : sortedHeaders) {
            canonicalizedHeaders = "" + canonicalizedHeaders + "" + header + ":" + com.aliyun.darabonbastring.Client.trim((String)headers.get(header)) + "\n";
        }
        return canonicalizedHeaders;
    }

    public List<String> getSignedHeaders(Map<String, String> headers) throws Exception {
        List headersArray = com.aliyun.darabonba.map.Client.keySet(headers);
        List sortedHeadersArray = com.aliyun.darabonba.array.Client.ascSort((List)headersArray);
        String tmp = "";
        String separator = "";
        for (String key : sortedHeadersArray) {
            String lowerKey = com.aliyun.darabonbastring.Client.toLower((String)key);
            if (!com.aliyun.darabonbastring.Client.hasPrefix((String)lowerKey, (String)"x-acs-").booleanValue() && !com.aliyun.darabonbastring.Client.equals((String)lowerKey, (String)"host").booleanValue() && !com.aliyun.darabonbastring.Client.equals((String)lowerKey, (String)"content-type").booleanValue() || com.aliyun.darabonbastring.Client.contains((String)tmp, (String)lowerKey).booleanValue()) continue;
            tmp = "" + tmp + "" + separator + "" + lowerKey + "";
            separator = ";";
        }
        return com.aliyun.darabonbastring.Client.split((String)tmp, (String)";", null);
    }
}

