/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.alink.linksdk.channel.core.persistent;

import com.aliyun.alink.linksdk.channel.core.base.ARequest;
import com.aliyun.alink.linksdk.channel.core.base.ASend;
import com.aliyun.alink.linksdk.channel.core.base.IOnCallListener;
import com.aliyun.alink.linksdk.channel.core.persistent.IOnSubscribeListener;
import com.aliyun.alink.linksdk.channel.core.persistent.IOnSubscribeRrpcListener;
import com.aliyun.alink.linksdk.channel.core.persistent.IPersisitentNet;
import com.aliyun.alink.linksdk.channel.core.persistent.PersistentConnectState;
import com.aliyun.alink.linksdk.channel.core.persistent.PersistentInitParams;
import com.aliyun.alink.linksdk.channel.core.persistent.PersistentRequest;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.MqttNet;
import com.aliyun.alink.utils.LogUtils;

public class PersistentNet
implements IPersisitentNet {
    private static String TAG = "PersistentNet";
    private static String NETPRO_MQTT = "MQTT";
    private static String SDK_VER = "0.3.0";
    private String netpro = NETPRO_MQTT;
    private IPersisitentNet iPersisitentNet = null;

    public static PersistentNet getInstance() {
        return InstanceHolder.sInstance;
    }

    public void setDefaultProtocol(String protocol) {
        if (protocol != null && protocol.equals(NETPRO_MQTT)) {
            this.netpro = NETPRO_MQTT;
            this.iPersisitentNet = MqttNet.getInstance();
        }
    }

    public String getDefaultProtocol() {
        return this.netpro;
    }

    @Override
    public void init(PersistentInitParams initParams) {
        LogUtils.print(TAG, "init(), SDK Ver = " + SDK_VER);
        this.getINet().init(initParams);
    }

    @Override
    public void destroy() {
        this.getINet().destroy();
    }

    public PersistentInitParams getInitParams() {
        IPersisitentNet iNet = this.getINet();
        if (iNet instanceof MqttNet) {
            return ((MqttNet)iNet).getInitParams();
        }
        return null;
    }

    @Override
    public PersistentConnectState getConnectState() {
        return this.getINet().getConnectState();
    }

    @Override
    public ASend asyncSend(ARequest request, IOnCallListener listener) {
        PersistentRequest pRequest = (PersistentRequest)request;
        return this.getINet().asyncSend(pRequest, listener);
    }

    @Override
    public void retry(ASend connect) {
        this.getINet().retry(connect);
    }

    @Override
    public void subscribe(String topic, IOnSubscribeListener listener) {
        this.getINet().subscribe(topic, listener);
    }

    @Override
    public void unSubscribe(String topic, IOnSubscribeListener listener) {
        this.getINet().unSubscribe(topic, listener);
    }

    @Override
    public void subscribeRrpc(String topic, IOnSubscribeRrpcListener listener) {
        this.getINet().subscribeRrpc(topic, listener);
    }

    private IPersisitentNet getINet() {
        if (this.iPersisitentNet == null) {
            this.iPersisitentNet = MqttNet.getInstance();
        }
        return this.iPersisitentNet;
    }

    public static void main(String[] args) {
        System.out.print("test");
    }

    private static class InstanceHolder {
        private static final PersistentNet sInstance = new PersistentNet();

        private InstanceHolder() {
        }
    }
}

