/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.alink.linksdk.channel.core.persistent.event;

import com.aliyun.alink.linksdk.channel.core.persistent.event.IConnectionStateListener;
import com.aliyun.alink.linksdk.channel.core.persistent.event.INetSessionStateListener;
import com.aliyun.alink.linksdk.channel.core.persistent.event.IOnPushListener;
import com.aliyun.alink.utils.LogUtils;
import java.util.HashMap;
import java.util.Set;
import javax.swing.SwingUtilities;

public class PersistentEventDispatcher {
    private static final String TAG = PersistentEventDispatcher.class.getName();
    public static final byte MSG_CONNECTED = 1;
    public static final byte MSG_DISCONNECT = 2;
    public static final byte MSG_CONNECT_FAIL = 7;
    public static final byte MSG_RECEIVECMD = 3;
    public static final byte MSG_NEEDLOGIN = 4;
    public static final byte MSG_SESSION_EFFECTIVE = 5;
    public static final byte MSG_SESSION_INVALID = 6;
    protected HashMap<IOnPushListener, Boolean> onPushListeners = null;
    protected HashMap<IConnectionStateListener, Boolean> tunnelListeners = null;
    protected HashMap<INetSessionStateListener, Boolean> sessionListeners = null;

    private PersistentEventDispatcher() {
    }

    public static PersistentEventDispatcher getInstance() {
        return InstanceHolder.sInstance;
    }

    void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnPushListener(IOnPushListener listener, boolean needUISafety) {
        LogUtils.print(TAG, "registerOnPushListener()");
        PersistentEventDispatcher persistentEventDispatcher = this;
        synchronized (persistentEventDispatcher) {
            if (null == listener) {
                return;
            }
            if (null == this.onPushListeners) {
                this.onPushListeners = new HashMap();
            }
            this.onPushListeners.put(listener, needUISafety);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnPushListener(IOnPushListener listener) {
        LogUtils.print(TAG, "unregisterOnPushListener()");
        PersistentEventDispatcher persistentEventDispatcher = this;
        synchronized (persistentEventDispatcher) {
            if (null == listener || null == this.onPushListeners || 0 >= this.onPushListeners.size()) {
                return;
            }
            this.onPushListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnTunnelStateListener(IConnectionStateListener listener, boolean needUISafety) {
        LogUtils.print(TAG, "registerOnTunnelStateListener()");
        PersistentEventDispatcher persistentEventDispatcher = this;
        synchronized (persistentEventDispatcher) {
            if (null == listener) {
                return;
            }
            if (null == this.tunnelListeners) {
                this.tunnelListeners = new HashMap();
            }
            this.tunnelListeners.put(listener, needUISafety);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnTunnelStateListener(IConnectionStateListener listener) {
        LogUtils.print(TAG, "unregisterOnTunnelStateListener()");
        PersistentEventDispatcher persistentEventDispatcher = this;
        synchronized (persistentEventDispatcher) {
            if (null == listener || null == this.tunnelListeners || 0 >= this.tunnelListeners.size()) {
                return;
            }
            this.tunnelListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNetSessionStateListener(INetSessionStateListener listener, boolean needUISafety) {
        LogUtils.print(TAG, "registerNetSessionStateListener()");
        PersistentEventDispatcher persistentEventDispatcher = this;
        synchronized (persistentEventDispatcher) {
            if (null == listener) {
                return;
            }
            if (null == this.sessionListeners) {
                this.sessionListeners = new HashMap();
            }
            this.sessionListeners.put(listener, needUISafety);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterNetSessionStateListener(INetSessionStateListener listener) {
        LogUtils.print(TAG, "unregisterNetSessionStateListener()");
        PersistentEventDispatcher persistentEventDispatcher = this;
        synchronized (persistentEventDispatcher) {
            if (null == listener || null == this.sessionListeners || 0 >= this.sessionListeners.size()) {
                return;
            }
            this.sessionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastMessage(int what, String method, byte[] content, String message) {
        LogUtils.print(TAG, "broadcastMessage(), what=" + what);
        PersistentEventDispatcher persistentEventDispatcher = this;
        synchronized (persistentEventDispatcher) {
            if (what == 3 && this.onPushListeners != null) {
                Set<IOnPushListener> listeners = this.onPushListeners.keySet();
                for (IOnPushListener listener : this.onPushListeners.keySet()) {
                    if (!listener.shouldHandle(method)) continue;
                    if (this.onPushListeners.get(listener).booleanValue()) {
                        PersistentEventDispatcher.doNotify(3, listener, method, content);
                        continue;
                    }
                    listener.onCommand(method, content);
                }
            } else if (what == 1 || what == 2 || what == 7) {
                if (this.tunnelListeners != null) {
                    Set<IConnectionStateListener> listeners = this.tunnelListeners.keySet();
                    for (IConnectionStateListener listener : listeners) {
                        if (this.tunnelListeners.get(listener).booleanValue()) {
                            PersistentEventDispatcher.doNotify(what, listener, message);
                            continue;
                        }
                        PersistentEventDispatcher.OnTunnelState(what, listener, message);
                    }
                }
            } else if ((what == 5 || what == 6 || what == 4) && this.sessionListeners != null) {
                Set<INetSessionStateListener> listeners = this.sessionListeners.keySet();
                for (INetSessionStateListener listener : listeners) {
                    if (this.sessionListeners.get(listener).booleanValue()) {
                        PersistentEventDispatcher.doNotify(what, listener, null);
                        continue;
                    }
                    PersistentEventDispatcher.OnSessionState(what, listener);
                }
            }
        }
    }

    private static void doNotify(final int what, final Object listener, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PersistentEventDispatcher.OnTunnelState(what, (IConnectionStateListener)listener, message);
            }
        });
    }

    private static void doNotify(final int what, final Object listener, final String method, final byte[] payload) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (listener instanceof IOnPushListener) {
                    IOnPushListener cb = (IOnPushListener)listener;
                    if (what == 3) {
                        cb.onCommand(method, payload);
                    }
                } else if (listener instanceof INetSessionStateListener) {
                    PersistentEventDispatcher.OnSessionState(what, (INetSessionStateListener)listener);
                }
            }
        });
    }

    static void OnTunnelState(int type, IConnectionStateListener listener, String content) {
        if (listener != null) {
            try {
                if (type == 1) {
                    listener.onConnected();
                } else if (type == 2) {
                    listener.onDisconnect();
                } else if (type == 7) {
                    listener.onConnectFail(content);
                }
            }
            catch (Exception e) {
                LogUtils.error(TAG, "catch exception from IConnectionStateListener");
            }
        }
    }

    static void OnSessionState(int type, INetSessionStateListener listener) {
        LogUtils.print(TAG, "OnSessionState()");
        if (listener != null) {
            try {
                if (type == 5) {
                    listener.onSessionEffective();
                } else if (type == 6) {
                    listener.onSessionInvalid();
                } else if (type == 4) {
                    listener.onNeedLogin();
                }
            }
            catch (Exception e) {
                LogUtils.error(TAG, "catch exception from INetSessionStateListener");
            }
        }
    }

    private static class InstanceHolder {
        private static final PersistentEventDispatcher sInstance = new PersistentEventDispatcher();

        private InstanceHolder() {
        }

        static {
            sInstance.init();
        }
    }
}

