/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.alink.linksdk.channel.core.persistent.mqtt.send;

import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.request.MqttPublishRequest;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.send.MqttSend;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.utils.MqttAlinkProtocolHelper;
import com.aliyun.alink.utils.LogUtils;
import com.aliyun.alink.utils.TextUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttRpcMessageCallback
implements IMqttMessageListener {
    private static final String TAG = "MqttRpcMessageCallback";
    private static Map<String, MqttSend> messageMap;

    public MqttRpcMessageCallback(String topic, MqttSend mqttSend) {
        if (messageMap == null) {
            messageMap = new HashMap<String, MqttSend>();
        }
        if (mqttSend == null || TextUtils.isEmpty(topic) || mqttSend.getRequest() == null || !(mqttSend.getRequest() instanceof MqttPublishRequest) || TextUtils.isEmpty(((MqttPublishRequest)mqttSend.getRequest()).msgId)) {
            return;
        }
        messageMap.put(topic + ",id=" + ((MqttPublishRequest)mqttSend.getRequest()).msgId, mqttSend);
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        LogUtils.print(TAG, "messageArrived()");
        if (TextUtils.isEmpty(topic)) {
            return;
        }
        String msgid = MqttAlinkProtocolHelper.parseMsgIdFromPayload(message.toString());
        if (TextUtils.isEmpty(msgid) || !messageMap.containsKey(topic + ",id=" + msgid)) {
            return;
        }
        LogUtils.print(TAG, "messageArrived(), match Id = <" + topic + ",id=" + msgid + ">");
        MqttSend mqttSend = messageMap.get(topic + ",id=" + msgid);
        mqttSend.rpcMessageArrived(topic, message);
        messageMap.remove(topic + ",id=" + msgid);
    }
}

