/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.alink.linksdk.channel.core.persistent.mqtt.send;

import com.aliyun.alink.linksdk.channel.core.base.AError;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.request.MqttSubscribeRequest;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.send.MqttSend;

public class MqttSendResponseRunnable
implements Runnable {
    public static final byte MSG_PUBLISH_SUCCESS = 1;
    public static final byte MSG_PUBLISH_FAILED = 2;
    public static final byte MSG_PUBLISH_BADNET = 3;
    public static final byte MSG_SUBSRIBE_SUCCESS = 4;
    public static final byte MSG_SUBSRIBE_FAILED = 5;
    public static final byte MSG_SUBSRIBE_BADNET = 6;
    private MqttSend sendObj = null;
    private byte msgType = 0;
    private String errorMsg = null;

    public MqttSendResponseRunnable(MqttSend send, byte type, String errorMsg) {
        this.sendObj = send;
        this.msgType = type;
        this.errorMsg = errorMsg;
    }

    @Override
    public void run() {
        if (null == this.sendObj) {
            return;
        }
        switch (this.msgType) {
            case 1: {
                if (this.sendObj.getListener() == null) {
                    return;
                }
                this.sendObj.getListener().onSuccess(this.sendObj.getRequest(), this.sendObj.getResponse());
                break;
            }
            case 2: 
            case 3: {
                if (this.sendObj.getListener() == null) {
                    return;
                }
                AError error = new AError();
                if (this.msgType == 3) {
                    error.setCode(4101);
                } else {
                    error.setCode(4201);
                }
                error.setMsg(this.errorMsg);
                this.sendObj.getListener().onFailed(this.sendObj.getRequest(), error);
                break;
            }
            case 4: {
                if (this.sendObj.getSubscribeListener() == null) {
                    return;
                }
                this.sendObj.getSubscribeListener().onSuccess(((MqttSubscribeRequest)this.sendObj.getRequest()).topic);
                break;
            }
            case 5: 
            case 6: {
                if (this.sendObj.getSubscribeListener() == null) {
                    return;
                }
                AError error1 = new AError();
                if (this.msgType == 3) {
                    error1.setCode(4101);
                } else {
                    error1.setCode(4201);
                }
                error1.setMsg(this.errorMsg);
                this.sendObj.getSubscribeListener().onFailed(((MqttSubscribeRequest)this.sendObj.getRequest()).topic, error1);
            }
        }
    }
}

