/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.alink.utils;

import com.aliyun.alink.utils.LogUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.eclipse.paho.client.mqttv3.logging.Logger;

public class MqttLogger
implements Logger {
    private static final String TAG = "MqttPaho";
    private static SimpleDateFormat fm = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
    public static boolean isLoggable = false;
    private String logContext;

    public void initialise(ResourceBundle messageCatalog, String loggerID, String resourceName) {
        LogUtils.print(TAG, "initialise\uff0cloggerId = " + loggerID + " , name = " + resourceName);
    }

    public void setResourceName(String logContext) {
        LogUtils.print(TAG, "setResourceName(), " + logContext);
        this.logContext = logContext;
    }

    public boolean isLoggable(int level) {
        return isLoggable;
    }

    public void severe(String sourceClass, String sourceMethod, String msg) {
        this.toALog("severe", sourceClass, sourceMethod, msg);
    }

    public void severe(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        this.toALog("severe", sourceClass, sourceMethod, msg, inserts);
    }

    public void severe(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
        this.toALog("severe", sourceClass, sourceMethod, msg, inserts);
    }

    public void warning(String sourceClass, String sourceMethod, String msg) {
        this.toALog("warning", sourceClass, sourceMethod, msg);
    }

    public void warning(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        this.toALog("warning", sourceClass, sourceMethod, msg, inserts);
    }

    public void warning(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
        this.toALog("warning", sourceClass, sourceMethod, msg, inserts);
    }

    public void info(String sourceClass, String sourceMethod, String msg) {
        this.toALog("info", sourceClass, sourceMethod, msg);
    }

    public void info(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        this.toALog("info", sourceClass, sourceMethod, msg, inserts);
    }

    public void info(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
        this.toALog("info", sourceClass, sourceMethod, msg, inserts);
    }

    public void config(String sourceClass, String sourceMethod, String msg) {
        this.toALog("config", sourceClass, sourceMethod, msg);
    }

    public void config(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        this.toALog("config", sourceClass, sourceMethod, msg, inserts);
    }

    public void config(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
        this.toALog("config", sourceClass, sourceMethod, msg, inserts);
    }

    public void fine(String sourceClass, String sourceMethod, String msg) {
        this.toALog("fine", sourceClass, sourceMethod, msg);
    }

    public void fine(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        this.toALog("fine", sourceClass, sourceMethod, msg, inserts);
    }

    public void fine(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {
        this.toALog("fine", sourceClass, sourceMethod, msg, inserts);
    }

    public void finer(String sourceClass, String sourceMethod, String msg) {
        this.toALog("finer", sourceClass, sourceMethod, msg);
    }

    public void finer(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        this.toALog("finer", sourceClass, sourceMethod, msg, inserts);
    }

    public void finer(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {
        this.toALog("finer", sourceClass, sourceMethod, msg, inserts);
    }

    public void finest(String sourceClass, String sourceMethod, String msg) {
        this.toALog("finest", sourceClass, sourceMethod, msg);
    }

    public void finest(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        this.toALog("finest", sourceClass, sourceMethod, msg, inserts);
    }

    public void finest(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {
        this.toALog("finest", sourceClass, sourceMethod, msg, inserts);
    }

    public void log(int level, String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
        this.toALog("log " + level, sourceClass, sourceMethod, msg, inserts);
    }

    public void trace(int level, String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {
        this.toALog("trace", sourceClass, sourceMethod, msg, inserts);
    }

    public String formatMessage(String msg, Object[] inserts) {
        return msg;
    }

    public void dumpTrace() {
        LogUtils.print(TAG, "dumpTrace()");
    }

    private void toALog(String logLevel, String sourceClass, String sourceMethod, String msg) {
        if (!isLoggable) {
            return;
        }
        this.print(TAG, logLevel + ", c= " + sourceClass + " , method = " + sourceMethod + " , msg = " + msg);
    }

    private void toALog(String logLevel, String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        if (!isLoggable) {
            return;
        }
        String parameters = "[";
        if (inserts != null && inserts.length > 0) {
            for (Object o : inserts) {
                if (o == null) continue;
                parameters = parameters + o.toString() + ", ";
            }
        }
        parameters = parameters + "]";
        this.print(TAG, logLevel + ", c= " + sourceClass + " , method = " + sourceMethod + " , msg = " + msg + "params:" + parameters);
    }

    private void print(String tag, String msg) {
        String source = null;
        try {
            StackTraceElement st = Thread.currentThread().getStackTrace()[4];
            source = "[" + st.getFileName() + "] - " + st.getMethodName() + "(" + st.getLineNumber() + ")-(" + Thread.currentThread().getId() + ")";
        }
        catch (Exception var4) {
            // empty catch block
        }
        System.out.println(fm.format(new Date()) + " - " + source + ":" + tag + ":" + msg);
    }
}

