/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.alink.linksdk.cmp.api;

import com.aliyun.alink.linksdk.cmp.api.CommonRequest;
import com.aliyun.alink.linksdk.cmp.api.CommonResource;
import com.aliyun.alink.linksdk.cmp.api.IConnectSDK;
import com.aliyun.alink.linksdk.cmp.connect.channel.MqttPublishRequest;
import com.aliyun.alink.linksdk.cmp.connect.channel.MqttRrpcRegisterRequest;
import com.aliyun.alink.linksdk.cmp.connect.channel.MqttSubscribeRequest;
import com.aliyun.alink.linksdk.cmp.connect.channel.PersistentConnectConfig;
import com.aliyun.alink.linksdk.cmp.connect.channel.PersistentRequest;
import com.aliyun.alink.linksdk.cmp.core.base.AConnect;
import com.aliyun.alink.linksdk.cmp.core.base.AConnectInfo;
import com.aliyun.alink.linksdk.cmp.core.base.AConnectOption;
import com.aliyun.alink.linksdk.cmp.core.base.ARequest;
import com.aliyun.alink.linksdk.cmp.core.base.AResource;
import com.aliyun.alink.linksdk.cmp.core.base.AResponse;
import com.aliyun.alink.linksdk.cmp.core.base.CmpError;
import com.aliyun.alink.linksdk.cmp.core.base.ConnectState;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectDiscovery;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectNotifyListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectPublishResourceListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectResourceRegister;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectRrpcListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectSendListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectSubscribeListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectUnscribeListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IResourceRequestListener;
import com.aliyun.alink.linksdk.cmp.core.util.ClassSwitchHelper;
import com.aliyun.alink.linksdk.cmp.manager.connect.ConnectManager;
import com.aliyun.alink.linksdk.cmp.manager.connect.IRegisterConnectListener;
import com.aliyun.alink.linksdk.cmp.manager.discovery.ConnectDiscoveryManager;
import com.aliyun.alink.linksdk.cmp.manager.resource.ConnectResourceManger;
import com.aliyun.alink.linksdk.tools.AError;
import com.aliyun.alink.linksdk.tools.ALog;

public class ConnectSDK
implements IConnectSDK {
    private static final String TAG = "ConnectSDK";

    public static IConnectSDK getInstance() {
        return InstanceHolder.sInstance;
    }

    @Override
    public void init() {
        ALog.d((String)TAG, (String)"init()");
        PersistentConnectConfig config = new PersistentConnectConfig();
        config.isInitUpdateFlag = true;
        ConnectManager.getInstance().registerPersistentConnect(config, null);
    }

    @Override
    public void registerPersistentConnect(PersistentConnectConfig connectConfig, IRegisterConnectListener listener) {
        ALog.d((String)TAG, (String)"registerPersistentConnect()");
        ConnectManager.getInstance().registerPersistentConnect(connectConfig, listener);
    }

    @Override
    public boolean isConnectRegisted(String connectId) {
        ALog.d((String)TAG, (String)("isConnectRegisted(), connectId = " + connectId));
        boolean flag = false;
        AConnect connect = ConnectManager.getInstance().getConnect(connectId);
        flag = connect != null;
        ALog.d((String)TAG, (String)("isConnectRegisted(), connectId = " + connectId + ", flag = " + flag));
        return flag;
    }

    @Override
    public ConnectState getConnectState(String connectId) {
        ALog.d((String)TAG, (String)"getConnectState()");
        return ConnectManager.getInstance().getConnectState(connectId);
    }

    @Override
    public AConnectInfo getConnectInfo(String connectId) {
        ALog.d((String)TAG, (String)"getConnectIndo");
        return ConnectManager.getInstance().getConnectInfo(connectId);
    }

    @Override
    public String getPersistentConnectId() {
        return "LINK_PERSISTENT";
    }

    @Override
    public void unregisterConnect(String connectId) {
        ConnectManager.getInstance().unregisterConnect(connectId);
    }

    @Override
    public void updateConnectOption(String connectId, AConnectOption option) {
        ALog.d((String)TAG, (String)("updateConnectOption, id = " + connectId));
        AConnect connect = ConnectManager.getInstance().getConnect(connectId);
        if (connect != null) {
            connect.updateConnectOption(option);
        }
    }

    @Override
    public void send(ARequest request, IConnectSendListener sendListener) {
        AConnect connect;
        ALog.d((String)TAG, (String)"send() common request");
        if (request == null) {
            if (sendListener != null) {
                CmpError cmpError = CmpError.PARAMS_ERROR();
                sendListener.onFailure(request, cmpError);
            }
            return;
        }
        String connectId = null;
        ARequest requestObj = request;
        if (request instanceof PersistentRequest) {
            connectId = this.getPersistentConnectId();
        }
        if ((connect = ConnectManager.getInstance().getConnect(connectId)) == null) {
            if (sendListener != null) {
                CmpError cmpError = CmpError.SEND_ERROR_CONNECT_NOT_FOUND();
                sendListener.onFailure(request, cmpError);
            }
            return;
        }
        connect.send(requestObj, sendListener);
    }

    @Override
    public void send(String connectId, ARequest request, IConnectSendListener sendListener) {
        ALog.d((String)TAG, (String)"send()");
        if (request == null) {
            if (sendListener != null) {
                CmpError cmpError = CmpError.PARAMS_ERROR();
                sendListener.onFailure(request, cmpError);
            }
            return;
        }
        AConnect connect = ConnectManager.getInstance().getConnect(connectId);
        if (connect == null) {
            if (sendListener != null) {
                CmpError cmpError = CmpError.SEND_ERROR_CONNECT_NOT_FOUND();
                sendListener.onFailure(request, cmpError);
            }
            return;
        }
        connect.send(request, sendListener);
    }

    @Override
    public void subscribe(String connectId, ARequest request, IConnectSubscribeListener subscribeListener) {
        ALog.d((String)TAG, (String)"subscribe()");
        if (request == null) {
            if (subscribeListener != null) {
                CmpError cmpError = CmpError.PARAMS_ERROR();
                subscribeListener.onFailure(cmpError);
            }
            return;
        }
        AConnect connect = ConnectManager.getInstance().getConnect(connectId);
        if (connect == null) {
            if (subscribeListener != null) {
                CmpError cmpError = CmpError.SEND_ERROR_CONNECT_NOT_FOUND();
                subscribeListener.onFailure(cmpError);
            }
            return;
        }
        if (request instanceof CommonRequest) {
            if (this.getPersistentConnectId().equals(connectId)) {
                MqttSubscribeRequest mqttSubscribeRequest = ClassSwitchHelper.commonReqToMqttSubReq((CommonRequest)request);
                connect.subscribe(mqttSubscribeRequest, subscribeListener);
            }
            return;
        }
        connect.subscribe(request, subscribeListener);
    }

    @Override
    public void unsubscribe(String connectId, ARequest request, IConnectUnscribeListener unscribeListener) {
        ALog.d((String)TAG, (String)"unsubscribe()");
        if (request == null) {
            if (unscribeListener != null) {
                CmpError cmpError = CmpError.PARAMS_ERROR();
                unscribeListener.onFailure(cmpError);
            }
            return;
        }
        AConnect connect = ConnectManager.getInstance().getConnect(connectId);
        if (connect == null) {
            if (unscribeListener != null) {
                CmpError cmpError = CmpError.SEND_ERROR_CONNECT_NOT_FOUND();
                unscribeListener.onFailure(cmpError);
            }
            return;
        }
        if (request instanceof CommonRequest) {
            if (this.getPersistentConnectId().equals(connectId)) {
                MqttSubscribeRequest mqttSubscribeRequest = ClassSwitchHelper.commonReqToMqttUnsubReq((CommonRequest)request);
                connect.unsubscribe(mqttSubscribeRequest, unscribeListener);
            }
            return;
        }
        connect.unsubscribe(request, unscribeListener);
    }

    @Override
    public void subscribeRrpc(String connectId, ARequest request, IConnectRrpcListener listener) {
        ALog.d((String)TAG, (String)("subscribeRrpc(),connectId = " + connectId));
        if (request == null) {
            if (listener != null) {
                CmpError cmpError = CmpError.PARAMS_ERROR();
                listener.onSubscribeFailed(request, cmpError);
            }
            return;
        }
        AConnect connect = ConnectManager.getInstance().getConnect(connectId);
        if (connect == null) {
            if (listener != null) {
                CmpError cmpError = CmpError.SEND_ERROR_CONNECT_NOT_FOUND();
                listener.onSubscribeFailed(request, cmpError);
            }
            return;
        }
        if (request instanceof CommonRequest) {
            MqttRrpcRegisterRequest request1 = ClassSwitchHelper.commonReqToMqttRrpcRegReq((CommonRequest)request);
            connect.subscribeRrpc(request1, listener);
            return;
        }
        connect.subscribeRrpc(request, listener);
    }

    @Override
    public void registerNofityListener(String connectId, IConnectNotifyListener connectNotifyListener) {
        ConnectManager.getInstance().registerNofityListener(connectId, connectNotifyListener);
    }

    @Override
    public void unregisterNofityListener(IConnectNotifyListener connectNotifyListener) {
        ConnectManager.getInstance().unregisterNofityListener(connectNotifyListener);
    }

    @Override
    public IConnectDiscovery getConnectDiscovery(String connnctId) {
        return ConnectDiscoveryManager.getDiscovery(connnctId);
    }

    @Override
    public IConnectResourceRegister getConnectResourceRegister(String connectId) {
        return ConnectResourceManger.getResourceRegister(connectId);
    }

    @Override
    public void registerResource(AResource resource, IResourceRequestListener listener) {
        ALog.d((String)TAG, (String)"registerResource()");
        if (resource == null) {
            ALog.d((String)TAG, (String)"registerResource(), resource is null");
            return;
        }
        if (resource instanceof CommonResource) {
            if (ConnectResourceManger.getPersistentResourceRegister() != null) {
                ConnectResourceManger.getPersistentResourceRegister().registerResource(resource, listener);
            }
        } else {
            ALog.d((String)TAG, (String)"registerResource(), resource is ");
        }
    }

    @Override
    public void publishResource(AResource resource, IConnectPublishResourceListener sendListener) {
        ALog.d((String)TAG, (String)"publishResource() common Resource");
        if (resource == null) {
            if (sendListener != null) {
                CmpError cmpError = CmpError.PARAMS_ERROR();
                sendListener.onFailure(resource, cmpError);
            }
            return;
        }
        ConnectPublishResourceListenerWrapper listenerWrapper = new ConnectPublishResourceListenerWrapper(resource, sendListener);
        if (resource instanceof CommonResource) {
            this.publishResourceWithMqtt(resource, listenerWrapper);
        } else if (sendListener != null) {
            CmpError cmpError = CmpError.PARAMS_ERROR();
            cmpError.setSubMsg("resource type not define");
            sendListener.onFailure(resource, cmpError);
        }
    }

    private void publishResourceWithMqtt(AResource resource, final ConnectPublishResourceListenerWrapper listenerWrapper) {
        ALog.d((String)TAG, (String)"publishResourceWithMqtt");
        AConnect connect = ConnectManager.getInstance().getConnect("LINK_PERSISTENT");
        if (connect == null) {
            CmpError cmpError = CmpError.SEND_ERROR_CONNECT_NOT_FOUND();
            listenerWrapper.onMqttFail(cmpError);
            return;
        }
        MqttPublishRequest request = new MqttPublishRequest();
        request.isRPC = false;
        request.topic = ((CommonResource)resource).topic;
        request.payloadObj = ((CommonResource)resource).payload;
        connect.send(request, new IConnectSendListener(){

            @Override
            public void onResponse(ARequest request, AResponse response) {
                listenerWrapper.onMqttSuccess();
            }

            @Override
            public void onFailure(ARequest request, AError error) {
                listenerWrapper.onMqttFail(error);
            }
        });
    }

    private class ConnectPublishResourceListenerWrapper {
        private IConnectPublishResourceListener listener;
        private AResource resource;
        private boolean isMqttConnectSuccess = false;
        private boolean isAlcsConnectSuccess = false;

        public ConnectPublishResourceListenerWrapper(AResource resource, IConnectPublishResourceListener listener) {
            this.resource = resource;
            this.listener = listener;
        }

        public void onMqttSuccess() {
            if (this.listener == null) {
                return;
            }
            this.listener.onSuccess(this.resource);
            this.listener = null;
            this.isMqttConnectSuccess = true;
        }

        public void onMqttFail(AError error) {
            if (this.listener == null) {
                return;
            }
            CmpError cmpError = CmpError.PUBLISH_RESOURCE_ERROR();
            cmpError.setSubCode(error.getCode());
            cmpError.setSubMsg(error.getMsg());
            this.listener.onFailure(this.resource, cmpError);
            this.listener = null;
        }
    }

    private static class InstanceHolder {
        private static final ConnectSDK sInstance = new ConnectSDK();

        private InstanceHolder() {
        }
    }
}

