/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.alink.linksdk.cmp.connect.channel;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.alink.linksdk.channel.core.base.AError;
import com.aliyun.alink.linksdk.channel.core.base.ARequest;
import com.aliyun.alink.linksdk.channel.core.base.IOnCallListener;
import com.aliyun.alink.linksdk.channel.core.persistent.IOnRrpcResponseHandle;
import com.aliyun.alink.linksdk.channel.core.persistent.IOnSubscribeListener;
import com.aliyun.alink.linksdk.channel.core.persistent.IOnSubscribeRrpcListener;
import com.aliyun.alink.linksdk.channel.core.persistent.PersistentConnectState;
import com.aliyun.alink.linksdk.channel.core.persistent.PersistentInitParams;
import com.aliyun.alink.linksdk.channel.core.persistent.PersistentNet;
import com.aliyun.alink.linksdk.channel.core.persistent.PersistentRequest;
import com.aliyun.alink.linksdk.channel.core.persistent.event.IConnectionStateListener;
import com.aliyun.alink.linksdk.channel.core.persistent.event.IOnPushListener;
import com.aliyun.alink.linksdk.channel.core.persistent.event.PersistentEventDispatcher;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.MqttConfigure;
import com.aliyun.alink.linksdk.channel.core.persistent.mqtt.MqttInitParams;
import com.aliyun.alink.linksdk.cmp.api.CommonResource;
import com.aliyun.alink.linksdk.cmp.api.ResourceRequest;
import com.aliyun.alink.linksdk.cmp.connect.channel.MqttPublishRequest;
import com.aliyun.alink.linksdk.cmp.connect.channel.MqttResource;
import com.aliyun.alink.linksdk.cmp.connect.channel.MqttRrpcRegisterRequest;
import com.aliyun.alink.linksdk.cmp.connect.channel.MqttRrpcRequest;
import com.aliyun.alink.linksdk.cmp.connect.channel.MqttSubscribeRequest;
import com.aliyun.alink.linksdk.cmp.connect.channel.PersistentConnectConfig;
import com.aliyun.alink.linksdk.cmp.connect.channel.PersistentConnectInfo;
import com.aliyun.alink.linksdk.cmp.core.base.AConnect;
import com.aliyun.alink.linksdk.cmp.core.base.AConnectConfig;
import com.aliyun.alink.linksdk.cmp.core.base.AMessage;
import com.aliyun.alink.linksdk.cmp.core.base.AResource;
import com.aliyun.alink.linksdk.cmp.core.base.AResponse;
import com.aliyun.alink.linksdk.cmp.core.base.CmpError;
import com.aliyun.alink.linksdk.cmp.core.base.ConnectState;
import com.aliyun.alink.linksdk.cmp.core.listener.IBaseListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectAuth;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectInitListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectNotifyListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectResourceRegister;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectRrpcHandle;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectRrpcListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectSendListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectSubscribeListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectUnscribeListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IResourceRequestListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IResourceResponseListener;
import com.aliyun.alink.linksdk.cmp.core.util.CallbackHelper;
import com.aliyun.alink.linksdk.cmp.core.util.ClassSwitchHelper;
import com.aliyun.alink.linksdk.tools.ALog;
import com.aliyun.alink.linksdk.tools.TextUtils;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class PersistentConnect
extends AConnect
implements IConnectResourceRegister,
IConnectAuth<Map<String, String>> {
    private static final String TAG = "PersistentConnect";
    public static final String CONNECT_ID = "LINK_PERSISTENT";
    private PersistentConnectConfig config;
    private MqttInitParams initParams;
    private ChannelStateListener channelStateListener = null;
    private DownstreamListener downstreamListener = null;
    private IConnectInitListener initListener;
    private PersistentConnectInfo persistentConnectInfo = null;
    private int PUSH_MSGID_QUEUE_MAX = 100;
    private Queue<String> pushMsgIdQueue;

    @Override
    public void init(AConnectConfig config, IConnectInitListener initListener) {
        ALog.d((String)TAG, (String)"init(),call");
        if (config == null || !(config instanceof PersistentConnectConfig) || !config.checkVaild()) {
            ALog.d((String)TAG, (String)"init()\uff0cparams error");
            CallbackHelper.paramError(initListener, "init, cxt or config is invalid");
            return;
        }
        this.connectId = CONNECT_ID;
        if (this.channelStateListener == null) {
            this.channelStateListener = new ChannelStateListener();
        }
        PersistentEventDispatcher.getInstance().registerOnTunnelStateListener((IConnectionStateListener)this.channelStateListener, true);
        if (this.downstreamListener == null) {
            this.downstreamListener = new DownstreamListener();
            PersistentEventDispatcher.getInstance().registerOnPushListener((IOnPushListener)this.downstreamListener, true);
        }
        if (PersistentNet.getInstance().getConnectState() == PersistentConnectState.CONNECTED) {
            ALog.d((String)TAG, (String)"initChannel(), already connected");
            this.updateConnectState(ConnectState.CONNECTED);
            this.updateConnectInfo();
            if (initListener != null) {
                initListener.onSuccess();
            }
            return;
        }
        if (((PersistentConnectConfig)config).isInitUpdateFlag) {
            if (initListener != null) {
                initListener.onFailure(null);
            }
            return;
        }
        this.updateConnectState(ConnectState.CONNECTING);
        this.config = (PersistentConnectConfig)config;
        this.initListener = initListener;
        if (!TextUtils.isEmpty((CharSequence)((PersistentConnectConfig)config).channelHost)) {
            ALog.d((String)TAG, (String)"init(),update host env config");
            MqttConfigure.mqttHost = ((PersistentConnectConfig)config).channelHost;
            MqttConfigure.isCheckRootCrt = ((PersistentConnectConfig)config).isCheckChannelRootCrt;
            MqttConfigure.mqttRootCrtFile = ((PersistentConnectConfig)config).channelRootCrtFile;
        }
        if (TextUtils.isEmpty((CharSequence)((PersistentConnectConfig)config).productKey) || TextUtils.isEmpty((CharSequence)((PersistentConnectConfig)config).deviceName) || TextUtils.isEmpty((CharSequence)((PersistentConnectConfig)config).deviceSecret)) {
            ALog.d((String)TAG, (String)"init(),need prepare auth");
            if (initListener != null) {
                initListener.onPrepareAuth(this);
            }
            return;
        }
        this.initParams = new MqttInitParams(((PersistentConnectConfig)config).productKey, ((PersistentConnectConfig)config).deviceName, ((PersistentConnectConfig)config).deviceSecret);
        this.initParams.receiveOfflineMsg = ((PersistentConnectConfig)config).receiveOfflineMsg;
        this.initChannel();
    }

    @Override
    public void onDestroy() {
        ALog.d((String)TAG, (String)"onDestroy()");
        if (this.channelStateListener != null) {
            PersistentEventDispatcher.getInstance().unregisterOnTunnelStateListener((IConnectionStateListener)this.channelStateListener);
            this.channelStateListener = null;
        }
        if (this.downstreamListener != null) {
            PersistentEventDispatcher.getInstance().unregisterOnPushListener((IOnPushListener)this.downstreamListener);
            this.downstreamListener = null;
        }
        PersistentNet.getInstance().destroy();
        this.updateConnectState(ConnectState.DISCONNECTED);
        this.connectInfo = null;
    }

    @Override
    public void setNotifyListener(IConnectNotifyListener notifyListener) {
        ALog.d((String)TAG, (String)("setNotifyListener(), listener = " + notifyListener));
        if (this.downstreamListener == null) {
            this.downstreamListener = new DownstreamListener();
            PersistentEventDispatcher.getInstance().registerOnPushListener((IOnPushListener)this.downstreamListener, true);
        }
        super.setNotifyListener(notifyListener);
    }

    @Override
    public void onAuth(Map<String, String> authInfo) {
        ALog.d((String)TAG, (String)"auth()");
        if (!(authInfo != null && authInfo.containsKey("PK") && authInfo.containsKey("DN") && authInfo.containsKey("DS"))) {
            if (this.initListener != null) {
                this.initListener.onFailure(CmpError.CONNECT_AUTH_INFO_ERROR());
                this.initListener = null;
            }
            return;
        }
        ALog.d((String)TAG, (String)"onAuth(), connect");
        this.initParams = new MqttInitParams(authInfo.get("PK"), authInfo.get("DN"), authInfo.get("DS"));
        this.initChannel();
    }

    @Override
    public void onPrepareAuthFail(com.aliyun.alink.linksdk.tools.AError error) {
        ALog.d((String)TAG, (String)"onPrepareFail()");
        if (this.initListener != null) {
            this.initListener.onFailure(error);
            this.initListener = null;
        }
    }

    private void initChannel() {
        ALog.d((String)TAG, (String)"initChannel()");
        if (PersistentNet.getInstance().getConnectState() == PersistentConnectState.CONNECTED) {
            ALog.d((String)TAG, (String)"initChannel(), already connected");
            this.updateConnectState(ConnectState.CONNECTED);
            this.updateConnectInfo();
            if (this.initListener != null) {
                this.initListener.onSuccess();
            }
            return;
        }
        PersistentNet.getInstance().init((PersistentInitParams)this.initParams);
    }

    private void updateConnectInfo() {
        ALog.d((String)TAG, (String)"updateConnectInfo()");
        PersistentInitParams initParams = PersistentNet.getInstance().getInitParams();
        if (initParams != null && initParams instanceof MqttInitParams) {
            if (this.persistentConnectInfo == null) {
                this.persistentConnectInfo = new PersistentConnectInfo();
            }
            this.persistentConnectInfo.productKey = ((MqttInitParams)initParams).productKey;
            this.persistentConnectInfo.deviceName = ((MqttInitParams)initParams).deviceName;
            this.connectInfo = this.persistentConnectInfo;
        }
    }

    @Override
    public void send(final com.aliyun.alink.linksdk.cmp.core.base.ARequest request, final IConnectSendListener sendListener) {
        ALog.d((String)TAG, (String)"send()");
        if (request instanceof MqttPublishRequest) {
            PersistentNet.getInstance().asyncSend((ARequest)ClassSwitchHelper.mqttPubReqCmpToChannel((MqttPublishRequest)request), new IOnCallListener(){

                public void onSuccess(ARequest aRequest, com.aliyun.alink.linksdk.channel.core.base.AResponse aResponse) {
                    if (sendListener == null) {
                        return;
                    }
                    sendListener.onResponse(request, ClassSwitchHelper.aRspChannelToCmp(aResponse));
                }

                public void onFailed(ARequest aRequest, AError aError) {
                    if (sendListener == null) {
                        return;
                    }
                    sendListener.onFailure(request, ClassSwitchHelper.aErrorChannelToCmp(aError));
                }

                public boolean needUISafety() {
                    return true;
                }
            });
        }
    }

    @Override
    public void subscribe(com.aliyun.alink.linksdk.cmp.core.base.ARequest subscribe, final IConnectSubscribeListener subscribeListener) {
        ALog.d((String)TAG, (String)"subscribe()");
        if (subscribe instanceof MqttSubscribeRequest) {
            PersistentNet.getInstance().subscribe(((MqttSubscribeRequest)subscribe).topic, new IOnSubscribeListener(){

                public void onSuccess(String s) {
                    if (subscribeListener != null) {
                        subscribeListener.onSuccess();
                    }
                }

                public void onFailed(String s, AError aError) {
                    if (subscribeListener != null) {
                        subscribeListener.onFailure(ClassSwitchHelper.aErrorChannelToCmp(aError));
                    }
                }

                public boolean needUISafety() {
                    return true;
                }
            });
        }
    }

    @Override
    public void unsubscribe(com.aliyun.alink.linksdk.cmp.core.base.ARequest subscribe, final IConnectUnscribeListener unscribeListener) {
        ALog.d((String)TAG, (String)"unsubscribe()");
        if (subscribe instanceof MqttSubscribeRequest) {
            PersistentNet.getInstance().unSubscribe(((MqttSubscribeRequest)subscribe).topic, new IOnSubscribeListener(){

                public void onSuccess(String s) {
                    if (unscribeListener != null) {
                        unscribeListener.onSuccess();
                    }
                }

                public void onFailed(String s, AError aError) {
                    if (unscribeListener != null) {
                        unscribeListener.onFailure(ClassSwitchHelper.aErrorChannelToCmp(aError));
                    }
                }

                public boolean needUISafety() {
                    return true;
                }
            });
        }
    }

    @Override
    public void subscribeRrpc(final com.aliyun.alink.linksdk.cmp.core.base.ARequest request, final IConnectRrpcListener rrpcListener) {
        ALog.d((String)TAG, (String)"subscribeRrpc()");
        if (request instanceof MqttRrpcRegisterRequest) {
            PersistentNet.getInstance().subscribeRrpc(((MqttRrpcRegisterRequest)request).topic, new IOnSubscribeRrpcListener(){

                public void onSubscribeSuccess(String topic) {
                    if (rrpcListener != null) {
                        rrpcListener.onSubscribeSuccess(request);
                    }
                }

                public void onSubscribeFailed(String topic, AError error) {
                    if (rrpcListener != null) {
                        rrpcListener.onSubscribeFailed(request, ClassSwitchHelper.aErrorChannelToCmp(error));
                    }
                }

                public void onReceived(String topic, PersistentRequest persistentRequest, final IOnRrpcResponseHandle handle) {
                    if (rrpcListener != null) {
                        MqttRrpcRequest rrpcRequest = new MqttRrpcRequest();
                        rrpcRequest.topic = topic;
                        rrpcRequest.payloadObj = persistentRequest.payloadObj;
                        if (!TextUtils.isEmpty((CharSequence)((MqttRrpcRegisterRequest)request).replyTopic)) {
                            rrpcRequest.replyTopic = ((MqttRrpcRegisterRequest)request).replyTopic;
                        } else if (persistentRequest instanceof com.aliyun.alink.linksdk.channel.core.persistent.mqtt.request.MqttRrpcRequest) {
                            rrpcRequest.replyTopic = ((com.aliyun.alink.linksdk.channel.core.persistent.mqtt.request.MqttRrpcRequest)persistentRequest).replyTopic;
                        }
                        rrpcListener.onReceived(rrpcRequest, new IConnectRrpcHandle(){

                            @Override
                            public void onRrpcResponse(String replyTopic, AResponse response) {
                                handle.onRrpcResponse(replyTopic, ClassSwitchHelper.aRspCmpToChannel(response));
                            }
                        });
                    }
                }

                public void onResponseSuccess(String topic) {
                    if (rrpcListener != null) {
                        rrpcListener.onResponseSuccess(request);
                    }
                }

                public void onResponseFailed(String topic, AError error) {
                    if (rrpcListener != null) {
                        rrpcListener.onResponseFailed(request, ClassSwitchHelper.aErrorChannelToCmp(error));
                    }
                }

                public boolean needUISafety() {
                    return true;
                }
            });
        }
    }

    @Override
    public void registerResource(AResource resource, IResourceRequestListener listener) {
        ALog.d((String)TAG, (String)"registerResource()");
        if (!(resource instanceof MqttResource) && !(resource instanceof CommonResource)) {
            if (listener != null) {
                listener.onFailure(CmpError.UNSUPPORT());
            }
            return;
        }
        MqttResource mqttResource = null;
        if (resource instanceof MqttResource) {
            mqttResource = (MqttResource)resource;
        } else if (resource instanceof CommonResource) {
            mqttResource = ClassSwitchHelper.commonResToMqttRes((CommonResource)resource);
        }
        PersistentNet.getInstance().subscribeRrpc(mqttResource.topic, (IOnSubscribeRrpcListener)new SubscribeRrpcListener(resource, listener));
    }

    @Override
    public void unregisterResource(AResource resource, IBaseListener listener) {
        ALog.d((String)TAG, (String)"unregisterResource()");
        if (listener != null) {
            listener.onFailure(CmpError.UNSUPPORT());
        }
    }

    @Override
    public void publishResource(AResource resource, final IBaseListener listener) {
        ALog.d((String)TAG, (String)"publishResource()");
        if (!(resource instanceof MqttResource) && !(resource instanceof CommonResource)) {
            if (listener != null) {
                listener.onFailure(CmpError.UNSUPPORT());
            }
            return;
        }
        MqttPublishRequest request = new MqttPublishRequest();
        request.isRPC = false;
        if (resource instanceof MqttResource) {
            request.topic = ((MqttResource)resource).topic;
            request.payloadObj = ((MqttResource)resource).content;
        } else if (resource instanceof CommonResource) {
            request.topic = ((CommonResource)resource).topic;
            request.payloadObj = ((CommonResource)resource).payload;
        }
        ALog.d((String)TAG, (String)"send()");
        this.send(request, new IConnectSendListener(){

            @Override
            public void onResponse(com.aliyun.alink.linksdk.cmp.core.base.ARequest request, AResponse response) {
                if (listener != null) {
                    listener.onSuccess();
                }
            }

            @Override
            public void onFailure(com.aliyun.alink.linksdk.cmp.core.base.ARequest request, com.aliyun.alink.linksdk.tools.AError error) {
                if (listener != null) {
                    listener.onFailure(error);
                }
            }
        });
    }

    private class SubscribeRrpcListener
    implements IOnSubscribeRrpcListener {
        private AResource resource;
        private IResourceRequestListener listener;

        public SubscribeRrpcListener(AResource resource, IResourceRequestListener listener) {
            this.resource = resource;
            this.listener = listener;
        }

        public void onSubscribeSuccess(String topic) {
            ALog.d((String)PersistentConnect.TAG, (String)("SubscribeRrpcListener, onSubscribeSuccess(), topic = " + topic));
            if (this.listener != null) {
                this.listener.onSuccess();
            }
        }

        public void onSubscribeFailed(String topic, AError error) {
            ALog.d((String)PersistentConnect.TAG, (String)("SubscribeRrpcListener, onSubscribeFailed(), topic = " + topic));
            if (this.listener != null) {
                this.listener.onFailure(ClassSwitchHelper.aErrorChannelToCmp(error));
            }
        }

        public void onReceived(String topic, PersistentRequest request, final IOnRrpcResponseHandle handle) {
            ALog.d((String)PersistentConnect.TAG, (String)("SubscribeRrpcListener, onReceived(), topic = " + topic));
            if (this.listener != null) {
                ResourceRequest resReq = new ResourceRequest();
                resReq.topic = topic;
                resReq.payloadObj = request.payloadObj;
                resReq.context = request;
                this.listener.onHandleRequest(this.resource, resReq, new IResourceResponseListener(){

                    @Override
                    public void onResponse(AResource resource, ResourceRequest resourceRequest, Object response) {
                        ALog.d((String)PersistentConnect.TAG, (String)"SubscribeRrpcListener, onReceived(),onResponse() call");
                        if (resource == null || !(resource instanceof MqttResource) && !(resource instanceof CommonResource) || response == null || !(response instanceof AResponse)) {
                            return;
                        }
                        String replyTopic = "";
                        if (resource instanceof MqttResource) {
                            replyTopic = ((MqttResource)resource).replyTopic;
                        } else if (resource instanceof CommonResource) {
                            replyTopic = ((CommonResource)resource).replyTopic;
                        }
                        ALog.d((String)PersistentConnect.TAG, (String)("SubscribeRrpcListener, onReceived(), onResponse(), rrpc rsp, replytopic = " + replyTopic));
                        handle.onRrpcResponse(replyTopic, ClassSwitchHelper.aRspCmpToChannel((AResponse)response));
                    }
                });
            }
        }

        public void onResponseSuccess(String topic) {
            ALog.d((String)PersistentConnect.TAG, (String)("SubscribeRrpcListener, onResponseSuccess(), topic = " + topic));
            if (this.listener != null) {
                this.listener.onSuccess();
            }
        }

        public void onResponseFailed(String topic, AError error) {
            ALog.d((String)PersistentConnect.TAG, (String)("SubscribeRrpcListener, onResponseFailed(), topic = " + topic));
            if (this.listener != null) {
                this.listener.onFailure(ClassSwitchHelper.aErrorChannelToCmp(error));
            }
        }

        public boolean needUISafety() {
            return true;
        }
    }

    private class DownstreamListener
    implements IOnPushListener {
        private DownstreamListener() {
        }

        public void onCommand(String s, byte[] s1) {
            ALog.d((String)PersistentConnect.TAG, (String)("onCommand(),topic = " + s));
            if (PersistentConnect.this.notifyListener == null) {
                return;
            }
            String dataStr = "";
            try {
                dataStr = new String(s1, "UTF-8");
                ALog.d((String)PersistentConnect.TAG, (String)("onCommand(),data = " + s1));
            }
            catch (Exception e) {
                ALog.d((String)PersistentConnect.TAG, (String)"onCommand(), to data error");
            }
            String msgId = this.getMsgId(dataStr);
            if (!TextUtils.isEmpty((CharSequence)msgId)) {
                if (PersistentConnect.this.pushMsgIdQueue == null) {
                    PersistentConnect.this.pushMsgIdQueue = new LinkedList();
                }
                String cache = s + "_" + msgId;
                if (PersistentConnect.this.pushMsgIdQueue.contains(cache)) {
                    return;
                }
                if (PersistentConnect.this.pushMsgIdQueue.size() < PersistentConnect.this.PUSH_MSGID_QUEUE_MAX) {
                    PersistentConnect.this.pushMsgIdQueue.offer(cache);
                } else {
                    PersistentConnect.this.pushMsgIdQueue.poll();
                    PersistentConnect.this.pushMsgIdQueue.offer(cache);
                }
            }
            AMessage msg = new AMessage();
            msg.data = s1;
            PersistentConnect.this.notifyListener.onNotify(PersistentConnect.CONNECT_ID, s, msg);
        }

        public boolean shouldHandle(String s) {
            ALog.d((String)PersistentConnect.TAG, (String)("shouldHandle(),topic =" + s));
            if (PersistentConnect.this.notifyListener == null) {
                return false;
            }
            return PersistentConnect.this.notifyListener.shouldHandle(PersistentConnect.CONNECT_ID, s);
        }

        private String getShortTopic(String compelteTopic) {
            String appDownFix;
            if (TextUtils.isEmpty((CharSequence)compelteTopic)) {
                return compelteTopic;
            }
            String preFix = "/sys/" + ((PersistentConnect)PersistentConnect.this).initParams.productKey + "/" + ((PersistentConnect)PersistentConnect.this).initParams.deviceName;
            String topic = compelteTopic;
            if (compelteTopic.contains(preFix)) {
                topic = compelteTopic.replace(preFix, "");
            }
            if (topic.contains(appDownFix = "/app/down")) {
                topic = topic.replace(appDownFix, "");
            }
            return topic;
        }

        private String getMsgId(String payload) {
            try {
                JSONObject payloadJson = JSONObject.parseObject((String)payload);
                if (payloadJson != null && payloadJson.containsKey((Object)"id")) {
                    return payloadJson.getString("id");
                }
            }
            catch (Exception e) {
                ALog.d((String)PersistentConnect.TAG, (String)("getMsgId(),error = " + e.toString()));
            }
            return null;
        }
    }

    private class ChannelStateListener
    implements IConnectionStateListener {
        private ChannelStateListener() {
        }

        public void onConnectFail(String msg) {
            ALog.d((String)PersistentConnect.TAG, (String)"onConnectFail()");
            if (PersistentConnect.this.initListener != null) {
                CmpError error = CmpError.MQTT_CONNECT_FAIL();
                error.setSubMsg(msg);
                PersistentConnect.this.initListener.onFailure(error);
                PersistentConnect.this.initListener = null;
            }
            PersistentConnect.this.updateConnectState(ConnectState.CONNECTFAIL);
        }

        public void onConnected() {
            ALog.d((String)PersistentConnect.TAG, (String)"onConnected()");
            if (PersistentConnect.this.initListener != null) {
                PersistentConnect.this.initListener.onSuccess();
                PersistentConnect.this.initListener = null;
            }
            PersistentConnect.this.updateConnectState(ConnectState.CONNECTED);
            PersistentConnect.this.updateConnectInfo();
        }

        public void onDisconnect() {
            ALog.d((String)PersistentConnect.TAG, (String)"onDisconnect()");
            PersistentConnect.this.updateConnectState(ConnectState.DISCONNECTED);
        }
    }
}

