/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.alink.linksdk.cmp.manager.connect;

import com.aliyun.alink.linksdk.cmp.connect.channel.PersistentConnect;
import com.aliyun.alink.linksdk.cmp.connect.channel.PersistentConnectConfig;
import com.aliyun.alink.linksdk.cmp.core.base.AConnect;
import com.aliyun.alink.linksdk.cmp.core.base.AConnectInfo;
import com.aliyun.alink.linksdk.cmp.core.base.AMessage;
import com.aliyun.alink.linksdk.cmp.core.base.CmpError;
import com.aliyun.alink.linksdk.cmp.core.base.ConnectState;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectAuth;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectInitListener;
import com.aliyun.alink.linksdk.cmp.core.listener.IConnectNotifyListener;
import com.aliyun.alink.linksdk.cmp.manager.connect.IRegisterConnectListener;
import com.aliyun.alink.linksdk.tools.AError;
import com.aliyun.alink.linksdk.tools.ALog;
import com.aliyun.alink.linksdk.tools.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectManager {
    private static final String TAG = "ConnectManager";
    private HashMap<String, AConnect> connectMap = new HashMap();
    private ConcurrentHashMap<IConnectNotifyListener, ArrayList<String>> notifyListeners;
    private CommonNotifyListener commonNotifyListener = null;
    private Map<String, String> alcsConnectsMap = null;
    private PersistentConnect persistentConnect = null;
    private boolean persistentConnectNotifyFlag = false;
    private boolean isPersistentConnectRegistering = false;

    public static ConnectManager getInstance() {
        return InstanceHolder.sInstance;
    }

    public void registerPersistentConnect(PersistentConnectConfig config, final IRegisterConnectListener listener) {
        ALog.d((String)TAG, (String)"registerPersistentConnect()");
        if (this.connectMap.containsKey("LINK_PERSISTENT")) {
            ALog.d((String)TAG, (String)"registerPersistentConnect(),REGISTER_CONNECT_ERROR_EXIST");
            if (listener != null) {
                new CmpError();
                listener.onFailure(CmpError.REGISTER_CONNECT_ERROR_EXIST());
            }
            return;
        }
        if (this.isPersistentConnectRegistering) {
            ALog.d((String)TAG, (String)"registerPersistentConnect(), is registering");
            if (listener != null) {
                new CmpError();
                listener.onFailure(CmpError.REGISTER_CONNECT_IS_REGISTERING());
            }
            return;
        }
        this.isPersistentConnectRegistering = true;
        if (this.persistentConnect == null) {
            this.persistentConnect = new PersistentConnect();
        }
        this.persistentConnect.init(config, new IConnectInitListener(){

            @Override
            public void onPrepareAuth(IConnectAuth connectAuth) {
                ALog.d((String)ConnectManager.TAG, (String)"registerPersistentConnect, onPrepareAuth()");
                ConnectManager.this.isPersistentConnectRegistering = false;
                if (listener != null) {
                    new CmpError();
                    listener.onFailure(CmpError.UNSUPPORT());
                }
            }

            @Override
            public void onSuccess() {
                ALog.d((String)ConnectManager.TAG, (String)"registerPersistentConnect, onSuccess()");
                ConnectManager.this.isPersistentConnectRegistering = false;
                ConnectManager.this.connectMap.put("LINK_PERSISTENT", ConnectManager.this.persistentConnect);
                if (listener != null) {
                    listener.onSuccess();
                }
            }

            @Override
            public void onFailure(AError error) {
                ALog.d((String)ConnectManager.TAG, (String)"registerPersistentConnect, onFailure()");
                ConnectManager.this.isPersistentConnectRegistering = false;
                if (listener != null) {
                    listener.onFailure(error);
                }
            }
        });
        if (!this.persistentConnectNotifyFlag) {
            if (this.commonNotifyListener == null) {
                this.commonNotifyListener = new CommonNotifyListener();
            }
            this.persistentConnect.setNotifyListener(this.commonNotifyListener);
            this.persistentConnectNotifyFlag = true;
        }
    }

    public void unregisterConnect(String connectId) {
        ALog.d((String)TAG, (String)("unregisterConnect(), connectId = " + connectId));
        if (TextUtils.isEmpty((CharSequence)connectId)) {
            return;
        }
        if (this.connectMap == null || this.connectMap.size() == 0) {
            return;
        }
        if (this.connectMap.containsKey(connectId)) {
            AConnect connect = this.connectMap.get(connectId);
            connect.onDestroy();
            this.connectMap.remove(connectId);
        }
        if (this.alcsConnectsMap.containsKey(connectId)) {
            this.alcsConnectsMap.remove(connectId);
        }
    }

    public AConnect getPersistentConnect() {
        return this.getConnect("LINK_PERSISTENT");
    }

    public AConnect getConnect(String connectId) {
        if (TextUtils.isEmpty((CharSequence)connectId) || !this.connectMap.containsKey(connectId)) {
            return null;
        }
        return this.connectMap.get(connectId);
    }

    public ConnectState getConnectState(String connectId) {
        ALog.d((String)TAG, (String)"getConnectState()");
        if (TextUtils.isEmpty((CharSequence)connectId) || !this.connectMap.containsKey(connectId)) {
            return null;
        }
        return this.connectMap.get(connectId).getConnectState();
    }

    public AConnectInfo getConnectInfo(String connectId) {
        ALog.d((String)TAG, (String)"getConnectInfo()");
        if (TextUtils.isEmpty((CharSequence)connectId) || !this.connectMap.containsKey(connectId)) {
            return null;
        }
        return this.connectMap.get(connectId).getConnectInfo();
    }

    public void registerNofityListener(String connectId, IConnectNotifyListener connectNotifyListener) {
        ALog.d((String)TAG, (String)("registerNofityListener(),connectId = " + connectId + ", listener = " + connectNotifyListener));
        if ("LINK_PERSISTENT".equals(connectId) && !this.persistentConnectNotifyFlag) {
            if (this.commonNotifyListener == null) {
                this.commonNotifyListener = new CommonNotifyListener();
            }
            if (this.persistentConnect == null) {
                this.persistentConnect = new PersistentConnect();
            }
            this.persistentConnect.setNotifyListener(this.commonNotifyListener);
            this.persistentConnectNotifyFlag = true;
        }
        if (this.notifyListeners == null) {
            this.notifyListeners = new ConcurrentHashMap();
        }
        if (connectNotifyListener == null) {
            return;
        }
        ArrayList<String> connectIds = this.notifyListeners.get(connectNotifyListener);
        if (connectIds == null) {
            connectIds = new ArrayList();
        }
        if (connectIds.contains(connectId)) {
            return;
        }
        connectIds.add(connectId);
        ALog.d((String)TAG, (String)("registerNofityListener(),listener = " + connectNotifyListener + ",size = " + connectIds.size()));
        this.notifyListeners.put(connectNotifyListener, connectIds);
    }

    public void unregisterNofityListener(IConnectNotifyListener connectNotifyListener) {
        ALog.d((String)TAG, (String)("unregisterNofityListener(),listener = " + connectNotifyListener));
        if (this.notifyListeners == null || connectNotifyListener == null || !this.notifyListeners.containsKey(connectNotifyListener)) {
            return;
        }
        ALog.d((String)TAG, (String)("unregisterNofityListener(),remove " + connectNotifyListener));
        this.notifyListeners.remove(connectNotifyListener);
    }

    private class CommonNotifyListener
    implements IConnectNotifyListener {
        private CommonNotifyListener() {
        }

        @Override
        public void onNotify(String connectId, String topic, AMessage data) {
            ALog.d((String)ConnectManager.TAG, (String)("onNotify(), connectId = " + connectId + " , topic = " + topic + ""));
            if (ConnectManager.this.notifyListeners == null || ConnectManager.this.notifyListeners.size() == 0) {
                return;
            }
            for (IConnectNotifyListener listener : ConnectManager.this.notifyListeners.keySet()) {
                ALog.d((String)ConnectManager.TAG, (String)("onNotify(),listener = " + listener));
                ArrayList ids = (ArrayList)ConnectManager.this.notifyListeners.get(listener);
                if (ids == null || !ids.contains(connectId)) continue;
                if (!listener.shouldHandle(connectId, topic)) {
                    ALog.d((String)ConnectManager.TAG, (String)"onNotify(),item should handle return false");
                    continue;
                }
                ALog.d((String)ConnectManager.TAG, (String)"onNotify(), send notify");
                listener.onNotify(connectId, topic, data);
            }
        }

        @Override
        public boolean shouldHandle(String connectId, String topic) {
            return true;
        }

        @Override
        public void onConnectStateChange(String connectId, ConnectState state) {
            ALog.d((String)ConnectManager.TAG, (String)("CommonNofity, onConnectStateChange(),state = " + (state != null ? state.name() : "null")));
            if (ConnectManager.this.notifyListeners == null || ConnectManager.this.notifyListeners.size() == 0) {
                return;
            }
            for (IConnectNotifyListener listener : ConnectManager.this.notifyListeners.keySet()) {
                ALog.d((String)ConnectManager.TAG, (String)("CommonNofity(),listener = " + listener));
                ArrayList ids = (ArrayList)ConnectManager.this.notifyListeners.get(listener);
                if (ids == null || !ids.contains(connectId)) continue;
                ALog.d((String)ConnectManager.TAG, (String)"CommonNofity, onConnectStateChange(), send notify");
                listener.onConnectStateChange(connectId, state);
            }
        }
    }

    private static class InstanceHolder {
        private static final ConnectManager sInstance = new ConnectManager();

        private InstanceHolder() {
        }
    }
}

