/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.clusterclient.partition;

import com.aliyun.drc.client.message.DataMessage;
import com.aliyun.drc.clusterclient.ClusterContext;
import com.aliyun.drc.clusterclient.impl.ClientCluster;
import com.aliyun.drc.clusterclient.partition.Checkpoint;
import com.aliyun.drc.clusterclient.partition.Partition;
import com.aliyun.drc.clustermanager.CommittedInfo;
import com.aliyun.drc.clustermanager.Register;
import com.aliyun.drc.clustermanager.RegisteredInfo;
import com.aliyun.drc.util.CheckpointLinkedList;
import com.aliyun.drc.util.CipherUtils;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionImpl
implements Partition {
    private static Logger logger = LoggerFactory.getLogger(PartitionImpl.class);
    private String guid;
    private String ip;
    private String seq;
    private String partition;
    private String topic;
    private Register register;
    private ClientCluster cluster;
    private ClusterContext clusterContext;
    private CheckpointLinkedList<DataMessage.Record> ckList = new CheckpointLinkedList();

    public PartitionImpl(String name) {
        this.partition = name;
    }

    @Override
    public void setClientCluster(ClientCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public void setRegister(Register register) {
        this.register = register;
    }

    @Override
    public void setClusterContext(ClusterContext clusterContext) {
        this.clusterContext = clusterContext;
    }

    @Override
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public final String getGuid() {
        return this.guid;
    }

    @Override
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Override
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Override
    public void setSeq(String seq) {
        this.seq = seq;
    }

    @Override
    public String getName() {
        return this.partition;
    }

    @Override
    public void ackAsConsumed(DataMessage.Record record) {
        this.ckList.removeElementFromCheckpointQueue(record);
    }

    @Override
    public void sendHeartbeat() {
        try {
            ArrayList<BasicNameValuePair> query = new ArrayList<BasicNameValuePair>();
            query.add(new BasicNameValuePair("ts", String.valueOf(System.currentTimeMillis())));
            query.add(new BasicNameValuePair("group", this.clusterContext.getConsumerGroup()));
            query.add(new BasicNameValuePair("guid", this.guid));
            query.add(new BasicNameValuePair("ip", this.ip));
            query.add(new BasicNameValuePair("seq", this.seq));
            query.add(new BasicNameValuePair("consumer", this.clusterContext.getUser()));
            query.add(new BasicNameValuePair("password", this.clusterContext.getPassword()));
            query.add(new BasicNameValuePair("partition", this.partition));
            query.add(new BasicNameValuePair("topic", this.topic));
            logger.info("sending partition heartbeat, group:" + this.clusterContext.getConsumerGroup() + ", guid:" + this.guid + ", partition:" + this.partition);
            HashMap<String, String> props = new HashMap<String, String>();
            String token = CipherUtils.encrypt(URLEncodedUtils.format(query, (Charset)Charset.defaultCharset()));
            props.put("token", token);
            RegisteredInfo response = this.register.registerClientAsActive(props);
            if (!response.getIsSuccess().booleanValue()) {
                logger.warn("Get error #" + response.getErrCode() + " " + response.getErrMsg() + "when sending heartbeat: " + query);
            }
        }
        catch (Exception e) {
            logger.warn("sending heartbeat exception. ", (Throwable)e);
        }
    }

    @Override
    public void forceActAsConsumed() throws Exception {
        DataMessage.Record record = this.ckList.getMin();
        if (record == null) {
            logger.warn("checkpoint to commit is null, wait for next round...");
            return;
        }
        Checkpoint checkpoint = new Checkpoint(record);
        ArrayList<BasicNameValuePair> query = new ArrayList<BasicNameValuePair>();
        query.add(new BasicNameValuePair("ts", String.valueOf(System.currentTimeMillis())));
        query.add(new BasicNameValuePair("group", this.clusterContext.getConsumerGroup()));
        query.add(new BasicNameValuePair("guid", this.guid));
        query.add(new BasicNameValuePair("ip", this.ip));
        query.add(new BasicNameValuePair("seq", this.seq));
        query.add(new BasicNameValuePair("consumer", this.clusterContext.getUser()));
        query.add(new BasicNameValuePair("password", this.clusterContext.getPassword()));
        query.add(new BasicNameValuePair("partition", this.partition));
        query.add(new BasicNameValuePair("offset", checkpoint.toString()));
        logger.info("sending partition commit, partition:" + this.partition + ", checkpoint:" + checkpoint.toString() + ", notAck:" + this.ckList.size());
        HashMap<String, String> props = new HashMap<String, String>();
        String token = CipherUtils.encrypt(URLEncodedUtils.format(query, (Charset)Charset.defaultCharset()));
        props.put("token", token);
        CommittedInfo response = this.register.commit(props);
        if (!response.getIsSuccess().booleanValue()) {
            logger.warn("Get error #" + response.getErrCode() + " " + response.getErrMsg() + "when sending commit: " + query);
            if (response.getErrCode() == 401 || response.getErrCode() == 443) {
                this.cluster.doStop(this.partition);
            }
        }
    }

    @Override
    public void pushRecordToPartition(DataMessage.Record record) {
        switch (record.getOpt()) {
            case HEARTBEAT: {
                this.ckList.pushHeartBeatElement(record);
                break;
            }
            default: {
                this.ckList.putElementCheckpointQueue(record);
            }
        }
    }

    public boolean equals(Object partitionImpl) {
        return ((PartitionImpl)partitionImpl).getName().equals(this.partition);
    }

    public int hashCode() {
        return this.partition.hashCode();
    }
}

