/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.drc.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class CheckpointLinkedList<E> {
    private static final int MAX_SIZE = 8192;
    private Entry<E> header = new Entry<Object>(null);
    private ReentrantLock lock = new ReentrantLock();
    private Condition full = this.lock.newCondition();
    private Map<E, Entry> entryMap = new ConcurrentHashMap<E, Entry>();
    private volatile E min;

    public CheckpointLinkedList() {
        this.header.setNext(this.header);
        this.header.setPrev(this.header);
    }

    public void putElementCheckpointQueue(E e) {
        try {
            this.lock.lock();
            if (this.entryMap.size() == 8192) {
                this.full.await();
            }
            Entry<E> entry = new Entry<E>(e);
            this.header.getPrev().setNext(entry);
            entry.setPrev(this.header.getPrev());
            entry.setNext(this.header);
            this.header.setPrev(entry);
            this.entryMap.put(e, entry);
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeElementFromCheckpointQueue(E e) {
        try {
            this.lock.lock();
            Entry entry = this.entryMap.get(e);
            if (entry.getPrev() == this.header) {
                this.min = e;
            }
            entry.getPrev().setNext(entry.getNext());
            entry.getNext().setPrev(entry.getPrev());
            this.entryMap.remove(e);
            this.full.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void pushHeartBeatElement(E e) {
        try {
            this.lock.lock();
            if (this.header.getNext().equals(this.header)) {
                this.min = e;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public E getMin() {
        return this.min;
    }

    public void setMin(E min) {
        this.min = min;
    }

    public int size() {
        return this.entryMap.size();
    }

    public class Entry<E> {
        private E element;
        private Entry<E> next;
        private Entry<E> prev;

        public Entry(E element) {
            this.element = element;
            this.prev = null;
            this.next = null;
        }

        public Entry(E element, Entry<E> next, Entry<E> prev) {
            this.element = element;
            this.next = next;
            this.prev = prev;
        }

        public void setNext(Entry<E> next) {
            this.next = next;
        }

        public void setPrev(Entry<E> prev) {
            this.prev = prev;
        }

        public Entry<E> getNext() {
            return this.next;
        }

        public Entry<E> getPrev() {
            return this.prev;
        }
    }
}

