package com.aliyun.drc.client;

import java.io.IOException;
import java.io.Reader;
import java.util.Properties;

import com.aliyun.drc.client.impl.DRCClientImpl;

public class DRCClientFactory {
	
	public enum Type {
		MYSQL,
		OCEANBASE,
		NONE
	};

	public static DRCClient create(final Type type, final Object arg) throws IOException {

		switch (type) {
		case MYSQL:
		case OCEANBASE:
			if (arg instanceof String)
				return new DRCClientImpl((String)arg);
			else if (arg instanceof Reader)
				return new DRCClientImpl((Reader)arg);
			else if (arg instanceof Properties)
				return new DRCClientImpl((Properties)arg);
			else
				return null;
		default:
			return null;
		}
	}
	
	public static DRCClient create(final Object arg) throws IOException {
		return create(Type.MYSQL, arg);
	}
}
