package com.aliyun.drc.client;

import com.aliyun.drc.client.message.DataMessage;

/**
 * Listeners are notified when a message comes. Users need implement the
 * interface and add it to @see DRCClient.
 */
public interface Listener {

    /**
     * Message is notified to the listener.
     * @param message message
     * @throws Exception Exception
     */
    public void notify(DataMessage message) throws Exception;

    /**
     * Message
     * @param level is log level.
     * @param log is log information.
     * @throws Exception Exception
     */
    public void notifyRuntimeLog(final String level, final String log) throws Exception;

    /**
     * Exceptions thrown out by @see notify is handled.
     * @param e is the handled exception.
     */
    public void handleException(Exception e);
}
