package com.aliyun.drc.client.impl;

import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.aliyun.drc.client.DRCClientException;
import com.aliyun.drc.client.HttpBadResponseException;
import com.aliyun.drc.client.enums.DBType;
import com.aliyun.drc.client.message.RedirectMessage;
import com.aliyun.drc.utils.CipherUtils;

import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class ClusterManagers {

	private static final String DELM = ";";
	private final String[] primUrls;
	public ClusterManagers(final String urls) {
		primUrls = urls.split(DELM);
	}

	public DBType getDatabaseType(final DRCConfig config)
			throws DRCClientException, UnknownHostException, MalformedURLException {

		StringBuilder builder = new StringBuilder();
		for (String url : primUrls) {

        	String[] managerUrls = NsLooker.getInstance().performNSLookup(url);
        	for (String managerUrl : managerUrls)
        	{
        		// looking for store
        		TokenResp t;
        		try {
        			t = ServerProxy.askToken(managerUrl,
        				config.getGroupName(), config.getIdentification(), config);
        		} catch (Exception e) {
        			builder.append(e.toString());
        			continue;
        		}

        		TopicsResp p;
        		try {
        			p = ServerProxy.askTopics(managerUrl, config.getDbname(), t.getToken(), config);
        		} catch (Exception e) {
        			builder.append(e.toString());
        			continue;
        		}

        		TypeResp tr;
        		try {
        			tr = ServerProxy.askTopicType(managerUrl, p.getTopics().get(0), config);
        		} catch (Exception e) {
        			builder.append(e.toString());
        			continue;
        		}

        		return tr.getDatabaseType();
        	}
		}

		throw new DRCClientException("Get exception from all cluster managers because " + builder.toString());
	}

	public ServerProxy findStore(final DRCConfig config, DRCClientImpl drcClient)
			throws Exception {

		if (primUrls.length == 1) {
			final String url = primUrls[0];
			java.net.URL parsedUrl = new java.net.URL(url);
			if (parsedUrl.getPath().length() > 1 && ServerProxy.askIfCm(url, config) == false) {
				return connectStore(url, "20" /* store token */, config, null, null, null);
			}
		}

		if (config != null) {
			// check persistent parameters.
            for (String persist : config.getPersists())
                if (config.getParam(persist) == null)
                    throw new DRCClientException("Required parameter " + persist + " is not given");
		}

		int index = -1;
		for (String url : primUrls) {
			index ++;
        	String[] managerUrls;
        	try {
        		managerUrls = NsLooker.getInstance().performNSLookup(url);
	    		int managerIndex = -1;
	        	for (String managerUrl : managerUrls)
	        	{
	        		try {
	        			managerIndex ++;
						List<NameValuePair> query = new ArrayList<NameValuePair>();
						query.add(new BasicNameValuePair("ts", "" + System.currentTimeMillis()));
						query.add(new BasicNameValuePair("consumer", config.getGroupName()));
						query.add(new BasicNameValuePair("password", config.getIdentification()));
						String token= CipherUtils.encrypt(URLEncodedUtils.format(query, Charset.defaultCharset()));
						TopicsResp p = ServerProxy.askTopics(managerUrl, config.getDbname(), token, config);
						//only first time we will ask topic type, reconnect will not do this operation
						if (null == drcClient.getDBType()) {
							TypeResp tr = ServerProxy.askTopicType(managerUrl, p.getTopics().get(0), config);
							drcClient.setDbType(tr.getDatabaseType());
							//in the mean time, we check if the data filter user set is legal
							if (false == drcClient.validateDataFilter()) {
								throw new DRCClientException("Data filter check failed: for oceanbase 1.0, the filter format must be " +
										" [tenant.dbname.tbname.clos]");
							}
						}
						StoreResp s = ServerProxy.askStore(managerUrl, p.getTopics().get(0), token, config);
						return connectStore(s.getStore(), p.getTopics().get(0), s.getToken(), config);

						// Below is origin code for internal aliabab
						/*
						TokenResp t = ServerProxy.askToken(managerUrl,
		       					config.getGroupName(), config.getIdentification(), config);
	        			TopicsResp p = ServerProxy.askTopics(managerUrl, config.getDbname(), t.getToken(), config);
                        ServerProxy.askRegionInfo(managerUrl,config,p.getTopics().get(0));
                        //only first time we will ask topic type, reconnect will not do this operation
                        if (null == drcClient.getDBType()) {
                            TypeResp tr = ServerProxy.askTopicType(managerUrl, p.getTopics().get(0), config);
                            drcClient.setDbType(tr.getDatabaseType());
                            //in the mean time, we check if the data filter user set is legal
                            if (false == drcClient.validateDataFilter()) {
                                throw new DRCClientException("Data filter check failed: for oceanbase 1.0, the filter format must be " +
                                        " [tenant.dbname.tbname.clos]");
                            }
                        }
	        			StoreResp s = ServerProxy.askStore(managerUrl, p.getTopics().get(0),
	        					t.getToken(), config);
	        			return connectStore(s.getStore(), p.getTopics().get(0), t.getToken(), config);
	        			*/
	        		} catch (DRCClientException nonretryExc) {
	        			throw nonretryExc;
	        		} catch (Exception retryExp) {
	        			// retryExp.printStackTrace();
	        			if (managerIndex + 1 == managerUrls.length) {
	        				throw retryExp;
	        			}
	        		}
	        	}
        	} catch (DRCClientException nonretryExp) {
        		throw nonretryExp;
        	} catch (Exception e) {
        		if (index + 1 == primUrls.length)
        			throw e;
        	}
		}

		throw new DRCClientException("Failed to recognize addresses of cluster manager: " +
				Arrays.toString(primUrls));
	}

	public ServerProxy connectStore(final String addr, final String subTopic,
			final String token, final DRCConfig config) throws Exception
	{
        String storeUrl;
        String []ipport ;
        ipport = addr.split(":");
        if (ipport.length != 2) {
            throw new DRCClientException("Store addr " + addr + " not ip:port");
        }
        storeUrl = (config.getUseHTTPS()?"https://":"http://") + ipport[0] + ":" + ipport[1] + "/" + subTopic;
        return connectStore(storeUrl, token, config, subTopic, ipport[0], ipport[1]);
	}

	
	public ServerProxy connectStore(final String storeUrl, final String token, final DRCConfig config, String subTopic, String ip, String port)
			throws Exception {

        ServerProxy server = new ServerProxy(storeUrl,config);
        server.setSocketTimeout(config.getSocketTimeout());
        server.setConnectionTimeout(config.getConnectionTimeout());
        server.addParam("token", token);
        final Checkpoint checkpoint = config.getCheckpoint();
        if (checkpoint.getTimestamp() != null && !checkpoint.getTimestamp().isEmpty()) {
        	server.addParam("checkpoint", checkpoint.getTimestamp());
        } else if (checkpoint.getPosition() != null) {
        	server.addParam("checkpoint", checkpoint.getPosition());
        	server.addParam("serverid", checkpoint.getServerId());
        } else {
        	throw new DRCClientException("Wrong checkpoint: " + checkpoint.toString());
        }

        int num = config.getNumOfRecordsPerBatch();
        if (num > 0) {
        	server.addParam("writer.threshold", Integer.toString(num));
        }
        //?????????????????????????????????text??????
        if (config.isBinaryFormat() && !config.getUseDrcNet()) {
        	/* Ask for data in the format of drc-message */
        	server.addParam("writer.type", "data");
        } else if(config.getUseDrcNet()  && config.isBinaryFormat() ) {
        	server.addParam("useDrcNet", "true");
        	server.addParam("writer.type", "sizedData");
        } else if(config.getUseDrcNet()  && !config.isBinaryFormat()) {
        	server.addParam("useDrcNet", "true");
        }
        
        if(config.getBlackList()!=null){
            server.addParam("filter.blacklist",config.getBlackList());
        }
        if (config.getGuid() != null) {
            server.addParam("guid", config.getGuid());
        }

        server.addParam("filter.conditions", config.getDataFilter().getConnectStoreFilterConditions());
        server.addParam("username", config.getGroupName());
        server.addParam("password", config.getIdentification());
        server.addParam("group", config.getGroup());
        server.addParam("subGroup", config.getSubGroup());

        if(config.isDrcMarkWorking()) {
        	/* Need only part of the data according to the area */
            server.addParam("filter.drcmark",config.getDRCMark());
            if (config.getDRCMark().startsWith("!")) {
            	/* Ask for data not generated in same the unit */
            	server.addParam("filter.alithreadid", "off");
            } else {
            	/* Ask for data generated in the same unit */
            	server.addParam("filter.alithreadid", "on");
            }
        }

        if (!config.isTxnMarkRequired()) {
        	server.addParam("filter.txn", "false");
        }

        if(config.isUseCaseSensitive()){
            server.addParam("casesensitive","true");
        }
      	if(config.isTrimLongType()){
            server.addParam("filter.longtype","true");
        }
      	server.addParam(DRCConfig.CLIENT_VERSION, DRCConfig.CLIENT_VERSION_ID);
        server.sendRequest(true);
        if(config.getUseDrcNet() == true && ip != null && port != null && subTopic != null) {
        	
        	server.addParam("topic", subTopic);
        	server.addParam("drcnet.encrypt", String.valueOf(config.getDrcNetEncrypt()));
        	server.conncetToDrcNetServer(ip, port, config.getConnectionTimeout());
        }
        return server;
	}

	public ServerProxy findClusterManager(final DRCConfig config, final RedirectMessage msg)
			throws HttpBadResponseException {

		ServerProxy server = null;
		for (String url : primUrls) {
            try {
            	String[] managerUrls = NsLooker.getInstance().performNSLookup(url);
            	for (String managerUrl : managerUrls)
            	{
                    server = new ServerProxy(managerUrl,config);
                    for (String parameterName : msg.getRequires()) {
                        final String value = config.getParam(parameterName);
                        if (value != null) {
                            server.addParam(parameterName, value);
                        } else {
                            throw new HttpBadResponseException(400, "Required parameter " +
                            		parameterName + " cannot be provided by client ");
                        }
                    }

                    for (String parameterName : msg.getOptional()) {
                        final String value = config.getParam(parameterName);
                       if (value != null) {
                           server.addParam(parameterName, value);
                       }
                    }

                    try {
                    	server.sendRequest(true);
                    	return server;
                    } catch (Exception e) {
                       server = null;
                    }
            	}
           } catch (Exception e) {
            	// ignore
           }
		}
		return null;
	}
}
